/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.NodeConfig;
import jp.co.toyoct.uecs.NodeRuntimeException;
import jp.co.toyoct.uecs.protocol.XmlCcmParser;
import jp.co.toyoct.uecs.tester.INodeListener;
import jp.co.toyoct.uecs.tester.TesterCcmService;
import jp.co.toyoct.uecs.tester.TesterConfig;
import jp.co.toyoct.uecs.tester.TesterUtil;
import jp.co.toyoct.uecs.tester.protocol.handler.TesterDataProtocolHandler;
import jp.co.toyoct.uecs.tester.protocol.handler.TesterScanProtocolHandler;
import jp.co.toyoct.uecs.tester.protocol.handler.TesterSearchProtocolHandler;

public class TesterNode
extends AbstractUecsNode {
    private static final String UECS_ID = "011001000001";
    private static final String VENDER = "TOYO_ICT_RESEARCH_CORP";
    private static final String NAME = "UecsTester";
    private Set<INodeListener> listeners = Collections.synchronizedSet(new HashSet());

    public TesterNode() {
        this(new TesterConfig());
    }

    public TesterNode(TesterConfig config) {
        this.addProtocol(new TesterDataProtocolHandler(this));
        this.addProtocol(new TesterSearchProtocolHandler(this));
        this.addProtocol(new TesterScanProtocolHandler(this));
        this.setup(config);
    }

    @Override
    public String getUecsID() {
        return UECS_ID;
    }

    @Override
    public String getVender() {
        return VENDER;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void addNodeListener(INodeListener lsn) {
        this.listeners.add(lsn);
    }

    public boolean removeNodeListener(INodeListener lsn) {
        return this.listeners.remove(lsn);
    }

    public Set<INodeListener> listenerSet() {
        return this.listeners;
    }

    @Override
    public void start() {
        if (!this.isActive()) {
            super.start();
            for (INodeListener lsn : this.listeners) {
                lsn.nodeStarted(this);
            }
        }
    }

    @Override
    public void stop() {
        if (this.isActive()) {
            super.stop();
            for (INodeListener lsn : this.listeners) {
                lsn.nodeStopped(this);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void sendPacket(InetAddress address, int port, byte[] data) {
        block4: {
            try {
                for (INodeListener lsn : this.listeners) {
                    ccmParser = new XmlCcmParser();
                    lsn.sendCcm(this, address, ccmParser.parseBytes(data));
                }
                super.sendPacket(address, port, data);
                break block4;
            }
            catch (Exception e) {
                ** for (lsn : this.listeners)
            }
lbl-1000:
            // 1 sources

            {
                lsn.sendError(this, address, data, e);
                continue;
            }
        }
    }

    @Override
    public void setup(NodeConfig config) {
        super.setup(config);
        try {
            Ccm ccm;
            TesterConfig conf = (TesterConfig)config;
            int i = 0;
            while ((ccm = conf.getCcm(i)) != null) {
                block7: {
                    TesterCcmService ccmsv;
                    block8: {
                        block6: {
                            ccmsv = null;
                            if (ccm.getSide() != 'S') break block6;
                            String var = conf.getDummyValues(i);
                            if (var == null || var.length() < 1) break block7;
                            double[] vals = TesterUtil.toArray(var);
                            int time = conf.getDummyInterval(i);
                            ccmsv = new TesterCcmService(ccm, time, vals);
                            break block8;
                        }
                        if (ccm.getLevel().getCategory() == 'B') {
                            int time = conf.getDummyInterval(i);
                            ccmsv = new TesterCcmService(ccm, time);
                        } else {
                            ccmsv = new TesterCcmService(ccm);
                        }
                    }
                    ccmsv.setEnable(conf.getBoolean("ccm." + i + "." + "enable", true));
                    this.addCcmService(ccmsv);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new NodeRuntimeException(e);
        }
        for (INodeListener lsn : this.listeners) {
            lsn.nodeSetup(this);
        }
    }
}

