/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester;

import java.io.IOException;
import java.util.List;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.CcmLevel;
import jp.co.toyoct.uecs.CcmService;
import jp.co.toyoct.uecs.CcmType;
import jp.co.toyoct.uecs.CommonUtils;
import jp.co.toyoct.uecs.NodeConfig;
import jp.co.toyoct.uecs.tester.TesterCcmService;
import jp.co.toyoct.uecs.tester.TesterNode;

public class TesterConfig
extends NodeConfig {
    private static final long serialVersionUID = 1L;
    public static final String CCM_TYPE = "type";
    public static final String CCM_LV = "LV";
    public static final String CCM_ROOM = "room";
    public static final String CCM_REGION = "region";
    public static final String CCM_ORDER = "order";
    public static final String CCM_PRIORITY = "priority";
    public static final String CCM_SR = "SR";
    public static final String CCM_CAST = "cast";
    public static final String CCM_UNIT = "unit";
    public static final String CCM_ENABLE = "enable";
    private static final String CCM_DUMMY_VALUES = "values";
    private static final String CCM_DUMMY_INTERVAL = "interval";

    public TesterConfig() {
    }

    public TesterConfig(String path) throws IOException {
        super(path);
    }

    public Ccm getCcm(int index) {
        String baseKey = "ccm." + index + ".";
        String type = this.getString(String.valueOf(baseKey) + CCM_TYPE);
        String lv = this.getString(String.valueOf(baseKey) + CCM_LV);
        if (type == null || lv == null) {
            return null;
        }
        char side = this.getString(String.valueOf(baseKey) + CCM_SR, "S").charAt(0);
        Ccm ccm = new Ccm();
        ccm.setUecsVersion(this.getString(String.valueOf(baseKey) + "uecs_version", "1.00-E10"));
        ccm.setCast(this.getInt(String.valueOf(baseKey) + CCM_CAST, 0));
        ccm.setUnit(this.getString(String.valueOf(baseKey) + CCM_UNIT, null));
        ccm.setType(new CcmType(type));
        ccm.setLevel(new CcmLevel(lv));
        ccm.setRoom(this.getInt(String.valueOf(baseKey) + CCM_ROOM, 0));
        ccm.setRegion(this.getInt(String.valueOf(baseKey) + CCM_REGION, 0));
        ccm.setOrder(this.getInt(String.valueOf(baseKey) + CCM_ORDER, 0));
        ccm.setPriority(this.getInt(String.valueOf(baseKey) + CCM_PRIORITY, 0));
        ccm.setSide(side);
        return ccm;
    }

    public static NodeConfig newInstance(TesterNode node) {
        NodeConfig instance = new NodeConfig();
        instance.setString("uecs_version", node.getUecsVersion());
        instance.setString("vender", node.getVender());
        instance.setString("name", node.getName());
        instance.setString("ip", node.getIpAddress().getHostAddress());
        instance.setString("mac", CommonUtils.bytesToHex(node.getMacAddress()));
        instance.setString("broadcast", node.getBroadcastAddress().getHostAddress());
        List<CcmService> ccmList = node.listCcmService();
        int i = 0;
        while (i < ccmList.size()) {
            CcmService ccmsv = ccmList.get(i);
            Ccm ccm = ccmsv.getCcm();
            String prefix = "ccm." + i + ".";
            instance.setBoolean(String.valueOf(prefix) + CCM_ENABLE, ccmsv.isEnable());
            if (ccm.getUecsVersion() != null) {
                instance.setString(String.valueOf(prefix) + "uecs_version", ccm.getUecsVersion());
            }
            if (ccm.getType() != null) {
                instance.setString(String.valueOf(prefix) + CCM_TYPE, ccm.getType().toString());
            }
            if (ccm.getRoom() >= 0) {
                instance.setInt(String.valueOf(prefix) + CCM_ROOM, ccm.getRoom());
            }
            if (ccm.getRegion() >= 0) {
                instance.setInt(String.valueOf(prefix) + CCM_REGION, ccm.getRegion());
            }
            if (ccm.getOrder() >= 0) {
                instance.setInt(String.valueOf(prefix) + CCM_ORDER, ccm.getOrder());
            }
            if (ccm.getPriority() >= 0) {
                instance.setInt(String.valueOf(prefix) + CCM_PRIORITY, ccm.getPriority());
            }
            if (ccm.getLevel() != null) {
                instance.setString(String.valueOf(prefix) + CCM_LV, ccm.getLevel().toString());
            }
            if (ccm.getSide() != '\u0000') {
                instance.setString(String.valueOf(prefix) + CCM_SR, "" + ccm.getSide());
            }
            if (ccm.getCast() > -1) {
                instance.setInt(String.valueOf(prefix) + CCM_CAST, ccm.getCast());
            }
            if (ccm.getUnit() != null) {
                instance.setString(String.valueOf(prefix) + CCM_UNIT, ccm.getUnit());
            }
            if (ccmsv instanceof TesterCcmService) {
                TesterCcmService dval = (TesterCcmService)ccmsv;
                instance.setInt(String.valueOf(prefix) + CCM_DUMMY_INTERVAL, dval.getInterval());
                StringBuilder sb = new StringBuilder();
                if (dval.getDummyValues() != null) {
                    double[] dArray = dval.getDummyValues();
                    int n = dArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double num = dArray[n2];
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(num);
                        ++n2;
                    }
                }
                instance.setString(String.valueOf(prefix) + CCM_DUMMY_VALUES, sb.toString());
            }
            ++i;
        }
        return instance;
    }

    public String getDummyValues(int ccmNo) {
        return this.getString("ccm." + ccmNo + "." + CCM_DUMMY_VALUES);
    }

    public void setDummyValues(int ccmNo, String varsStr) {
        this.setString("ccm." + ccmNo + "." + CCM_DUMMY_VALUES, varsStr);
    }

    public int getDummyInterval(int ccmNo) {
        return this.getInt("ccm." + ccmNo + "." + CCM_DUMMY_INTERVAL, 0);
    }

    public void setDummyInterval(int ccmNo, int sec) {
        this.setInt("ccm." + ccmNo + "." + CCM_DUMMY_INTERVAL, sec);
    }
}

