/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.tester;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.CcmService;

public class TesterCcmService
extends CcmService
implements Runnable {
    private double[] values;
    private int interval;
    private int index;
    private static ScheduledExecutorService dataExecutor;

    public TesterCcmService(Ccm ccm) {
        this(ccm, 0, new double[0]);
    }

    public TesterCcmService(Ccm ccm, int interval) {
        this(ccm, interval, new double[0]);
    }

    public TesterCcmService(Ccm ccm, int interval, double[] values) {
        super(ccm);
        this.values = values;
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int sec) {
        this.interval = sec;
    }

    public void setDummyValues(double[] vals) {
        this.values = vals;
    }

    public double[] getDummyValues() {
        return this.values;
    }

    @Override
    public void run() {
        Ccm ccm = this.getCcm();
        if (ccm.getSide() == 'S') {
            if (this.values == null || this.values.length == 0) {
                return;
            }
            this.updateValue(this.values[this.index++]);
            if (this.index >= this.values.length) {
                this.index = 0;
            }
        } else if (ccm.getSide() == 'R') {
            this.requestData();
        }
    }

    @Override
    protected void onStart(AbstractUecsNode node) throws Exception {
        if (dataExecutor == null) {
            dataExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        Ccm ccm = this.getCcm();
        if (this.isEnable() && this.getInterval() > 0 && (ccm.getSide() == 'S' || ccm.getSide() == 'R' && ccm.getLevel().getCategory() == 'B')) {
            dataExecutor.scheduleAtFixedRate(this, 0L, this.getInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    protected void onStop(AbstractUecsNode node) throws Exception {
        if (dataExecutor != null) {
            dataExecutor.shutdown();
            dataExecutor = null;
        }
    }
}

