/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs.protocol.handler;

import java.util.List;
import jp.co.toyoct.uecs.AbstractUecsNode;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.CcmService;
import jp.co.toyoct.uecs.UecsRequest;
import jp.co.toyoct.uecs.UecsResponse;
import jp.co.toyoct.uecs.protocol.RequestCcm;
import jp.co.toyoct.uecs.protocol.SearchCcm;
import jp.co.toyoct.uecs.protocol.ServerCcm;
import jp.co.toyoct.uecs.protocol.XmlCcm;
import jp.co.toyoct.uecs.protocol.handler.AbstractProtocolHandler;

public class SearchProtocolHandler
extends AbstractProtocolHandler {
    public SearchProtocolHandler(AbstractUecsNode node) {
        super(node);
    }

    @Override
    public int getPort() {
        return 16521;
    }

    @Override
    protected void handleCcm(UecsRequest req, UecsResponse res, XmlCcm ccm) throws Exception {
        if (ccm instanceof SearchCcm) {
            this.handleSearchCcm(req, res, (SearchCcm)ccm);
        } else if (ccm instanceof ServerCcm) {
            this.handleServerCcm(req, res, (ServerCcm)ccm);
        } else {
            throw new Exception("illegal packet : " + ccm.toString());
        }
    }

    private void handleSearchCcm(UecsRequest req, UecsResponse res, SearchCcm sccm) {
        AbstractUecsNode node = this.getNode();
        List<CcmService> list = node.listCcmService();
        for (CcmService sv : list) {
            Ccm dccm = sv.getCcm();
            if (dccm.getSide() != 'S' || dccm.getLevel().getCategory() != 'B' || !dccm.getType().equals(sccm.getType()) || sccm.getRoom() != 0 && dccm.getRoom() != sccm.getRoom() || sccm.getRegion() != 0 && dccm.getRegion() != sccm.getRegion() || sccm.getOrder() != 0 && dccm.getOrder() != sccm.getOrder()) continue;
            ServerCcm svccm = new ServerCcm();
            svccm.setUecsVersion(dccm.getUecsVersion());
            svccm.setType(dccm.getType());
            svccm.setRoom(dccm.getRoom());
            svccm.setRegion(dccm.getRegion());
            svccm.setOrder(dccm.getOrder());
            svccm.setPriority(dccm.getPriority());
            svccm.setIpAddress(node.getIpAddress());
            res.setAddress(node.getBroadcastAddress());
            res.setPort(svccm.getPort());
            res.setData(svccm.toXmlBytes());
        }
    }

    private void handleServerCcm(UecsRequest req, UecsResponse res, ServerCcm sccm) {
        AbstractUecsNode node = this.getNode();
        List<CcmService> list = node.listCcmService();
        for (CcmService sv : list) {
            Ccm dccm = sv.getCcm();
            if (dccm.getSide() != 'R' || dccm.getLevel().getCategory() != 'B' || !dccm.getType().equals(sccm.getType()) || sccm.getRoom() != 0 && dccm.getRoom() != sccm.getRoom() || sccm.getRegion() != 0 && dccm.getRegion() != sccm.getRegion() || sccm.getOrder() != 0 && dccm.getOrder() != sccm.getOrder()) continue;
            RequestCcm request = new RequestCcm();
            request.setUecsVersion(dccm.getUecsVersion());
            request.setType(dccm.getType());
            request.setRoom(dccm.getRoom());
            request.setRegion(dccm.getRegion());
            request.setOrder(dccm.getOrder());
            request.setPriority(dccm.getPriority());
            res.setAddress(req.getAddress());
            res.setPort(request.getPort());
            res.setData(request.toXmlBytes());
        }
    }
}

