/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class NodeConfig
extends Properties {
    private static final long serialVersionUID = -1148528853140933527L;
    public static final String VENDER = "vender";
    public static final String UECS_ID = "uecs_id";
    public static final String UECS_VERSION = "uecs_version";
    public static final String NODE_NAME = "name";
    public static final String NODE_IP = "ip";
    public static final String NODE_MAC = "mac";
    public static final String NODE_BROADCAST = "broadcast";

    public NodeConfig() {
    }

    public NodeConfig(String xmlPath) throws IOException {
        FileInputStream in = new FileInputStream(xmlPath);
        this.loadFromXML(in);
    }

    public String getString(String name) {
        return super.getProperty(name);
    }

    public String getString(String name, String defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return super.getProperty(name);
    }

    public short getShort(String name) {
        String val = this.getProperty(name, "0");
        return Short.parseShort(val);
    }

    public short getShort(String name, short defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return this.getShort(name);
    }

    public int getInt(String name) {
        String val = super.getProperty(name, "0");
        return Integer.parseInt(val);
    }

    public int getInt(String name, int defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return this.getInt(name);
    }

    public float getFloat(String name) {
        String val = super.getProperty(name, "0.0");
        return Float.parseFloat(val);
    }

    public float getFloat(String name, float defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return this.getFloat(name);
    }

    public double getDouble(String name) {
        String val = super.getProperty(name, "0.0");
        return Double.parseDouble(val);
    }

    public double getDouble(String name, double defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return this.getDouble(name);
    }

    public long getLong(String name) {
        String val = super.getProperty(name, "0");
        return Long.parseLong(val);
    }

    public long getLong(String name, long defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return this.getLong(name);
    }

    public boolean getBoolean(String name) {
        String val = super.getProperty(name, "false");
        return Boolean.parseBoolean(val);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        return this.getBoolean(name);
    }

    public Date getDate(String name) {
        return this.getDateTime(name, "yyyyMMdd");
    }

    public Date getDateTime(String name) {
        return this.getDateTime(name, "yyyyMMddHHmmss");
    }

    public Class<?> getClassObject(String name) {
        try {
            return Class.forName(this.getString(name));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Date getDateTime(String name, String format) {
        String val = super.getProperty(name);
        if (val == null) {
            return null;
        }
        if (val.length() > format.length()) {
            val = val.substring(0, format.length());
        }
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        try {
            return fmt.parse(val);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setString(String name, String val) {
        this.setProperty(name, val);
    }

    public void setShort(String name, Short val) {
        this.setProperty(name, Short.toString(val));
    }

    public void setInt(String name, int val) {
        this.setProperty(name, Integer.toString(val));
    }

    public void setLong(String name, long val) {
        this.setProperty(name, Long.toString(val));
    }

    public void setFloat(String name, float val) {
        this.setProperty(name, Float.toString(val));
    }

    public void setDouble(String name, double val) {
        this.setProperty(name, Double.toString(val));
    }

    public void setBoolean(String name, boolean val) {
        this.setProperty(name, Boolean.toString(val));
    }

    public void setDate(String name, Date val) {
        this.setDate(name, val, "yyyyMMddHHmmss");
    }

    public void setDate(String name, Date val, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        this.setProperty(name, fmt.format(val));
    }
}

