/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import jp.co.toyoct.uecs.CcmLevel;
import jp.co.toyoct.uecs.NodeRuntimeException;

public final class CcmType {
    public static final CcmLevel A_1S_0 = new CcmLevel("A-1S-0");
    public static final CcmLevel A_1S_1 = new CcmLevel("A-1S-1");
    public static final CcmLevel A_10S_0 = new CcmLevel("A-10S-0");
    public static final CcmLevel A_10S_1 = new CcmLevel("A-10S-1");
    public static final CcmLevel A_1M_0 = new CcmLevel("A-1M-0");
    public static final CcmLevel A_1M_1 = new CcmLevel("A-1M-1");
    public static final CcmLevel B_0 = new CcmLevel("B-0");
    public static final CcmLevel B_1 = new CcmLevel("B-1");
    public static final CcmLevel S_1S_0 = new CcmLevel("S-1S-0");
    public static final CcmLevel S_1M_0 = new CcmLevel("S-1M-0");
    private Category category;
    private String nodeType;
    private String itemName;
    private String code;

    protected CcmType() {
    }

    public CcmType(String code) {
        if (code == null || code.length() < 3 || code.length() > 19) {
            throw new NodeRuntimeException("ID length violation. code=" + code);
        }
        this.code = code;
        if (code.length() > 4 && code.charAt(code.length() - 4) == '.') {
            int sep = code.length() - 4;
            this.itemName = code.substring(0, sep);
            this.category = Category.toEnum(code.charAt(sep + 1));
            this.nodeType = code.substring(sep + 2);
        } else {
            this.itemName = code;
            this.category = null;
            this.nodeType = null;
        }
    }

    public String getItemName() {
        return this.itemName;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof CcmType) {
            return this.code.equals(((CcmType)o).code);
        }
        return false;
    }

    public static enum Category {
        Actuator("a"),
        Controller("c"),
        Measure("m"),
        Unknown("x");

        private String codeStr;

        private Category(String code) {
            this.codeStr = code;
        }

        public char getCode() {
            return this.codeStr.charAt(0);
        }

        public String toString() {
            return this.codeStr;
        }

        public static Category toEnum(char code) {
            switch (code) {
                case 'a': {
                    return Actuator;
                }
                case 'c': {
                    return Controller;
                }
                case 'm': {
                    return Measure;
                }
            }
            return Unknown;
        }
    }
}

