/*
 * Decompiled with CFR 0.152.
 */
package jp.co.toyoct.uecs;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jp.co.toyoct.uecs.ActionMode;
import jp.co.toyoct.uecs.Ccm;
import jp.co.toyoct.uecs.CcmService;
import jp.co.toyoct.uecs.IUecsProtocolHandler;
import jp.co.toyoct.uecs.NodeConfig;
import jp.co.toyoct.uecs.NodeRuntimeException;
import jp.co.toyoct.uecs.UecsRequest;
import jp.co.toyoct.uecs.UecsResponse;
import jp.co.toyoct.uecs.protocol.DataCcm;

public abstract class AbstractUecsNode {
    private static final String DELAY_TIME = "delay_time";
    private static final long DEFAULT_DELAY = 50L;
    private String uecsVersion;
    private InetAddress broadcastAddress;
    private InetAddress ipAddress;
    private byte[] macAddress;
    private String vender;
    private String uecsID;
    private DatagramSocket sendSocket = null;
    private NodeConfig config;
    private String name;
    private boolean isActive = false;
    private int status = 0;
    private ScheduledExecutorService cycleExecutor;
    private ExecutorService eventExecutor;
    private List<CcmService> ccmList = Collections.synchronizedList(new ArrayList());
    private List<UdpServer> servers = Collections.synchronizedList(new ArrayList());
    private List<IUecsProtocolHandler> protocols = Collections.synchronizedList(new ArrayList());

    public void addCcmService(CcmService ccm) {
        if (ccm != null) {
            ccm.setNode(this);
            this.ccmList.add(ccm);
        }
    }

    public void addProtocol(IUecsProtocolHandler protocol) {
        if (protocol != null) {
            this.protocols.add(protocol);
        }
    }

    public void clearCcmServices() {
        for (CcmService sv : this.ccmList) {
            sv.setNode(null);
        }
        this.ccmList.clear();
    }

    public int countCcm() {
        return this.ccmList.size();
    }

    void executeTask(Runnable task) {
        this.eventExecutor.execute(task);
    }

    public InetAddress getBroadcastAddress() {
        return this.broadcastAddress;
    }

    public int getCcmIndex(CcmService ccm) {
        return this.ccmList.indexOf(ccm);
    }

    public CcmService getCcmService(int index) {
        if (index < 0 || index > this.ccmList.size() - 1) {
            return null;
        }
        return this.ccmList.get(index);
    }

    public NodeConfig getConfig() {
        return this.config;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getUecsID() {
        return this.uecsID;
    }

    public String getUecsVersion() {
        return this.uecsVersion;
    }

    public String getVender() {
        return this.vender;
    }

    public int getStatus() {
        return this.status;
    }

    public ActionMode getActionMode() {
        int modeBits = this.status & 0xF0000;
        return ActionMode.getMode(modeBits);
    }

    public void setActionMode(ActionMode mode) {
        int modeBits = this.status & 0xF0000;
        this.status -= modeBits;
        this.status += mode.getBits();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public List<CcmService> listCcmService() {
        return new ArrayList<CcmService>(this.ccmList);
    }

    public CcmService removeCcmService(int index) {
        CcmService sv = this.ccmList.remove(index);
        if (sv != null) {
            sv.setNode(null);
        }
        return sv;
    }

    public void sendPacket(InetAddress address, int port, byte[] data) {
        try {
            DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
            this.sendSocket.send(packet);
        }
        catch (IOException e) {
            throw new NodeRuntimeException(e);
        }
    }

    public void setBroadcastAddress(InetAddress broadcastAddress) {
        this.broadcastAddress = broadcastAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
        if (ipAddress == null) {
            this.macAddress = null;
        } else {
            try {
                NetworkInterface nic = NetworkInterface.getByInetAddress(ipAddress);
                if (nic != null) {
                    this.macAddress = nic.getHardwareAddress();
                }
            }
            catch (SocketException e) {
                throw new NodeRuntimeException(e);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUecsID(String uecsID) {
        this.uecsID = uecsID;
    }

    public void setUecsVersion(String uecsVersion) {
        this.uecsVersion = uecsVersion;
        for (CcmService sv : this.ccmList) {
            sv.getCcm().setUecsVersion(uecsVersion);
        }
    }

    public void clearStatus() {
        this.status = 0;
    }

    public void onStatus(int status) {
        this.status |= status;
    }

    public void offStatus(int status) {
        if ((this.status & status) > 0) {
            this.status -= status;
        }
    }

    public void setup(NodeConfig config) {
        this.config = config;
        if (this.isActive()) {
            throw new NodeRuntimeException("node is active.");
        }
        this.clearStatus();
        this.clearCcmServices();
        this.setUecsVersion(config.getString("uecs_version", "1.00-E10"));
        this.setUecsID(config.getString("uecs_id", ""));
        this.setName(config.getString("name", ""));
        this.setVender(config.getString("vender", ""));
        try {
            String ip = config.getString("ip", "");
            InetAddress iadr = null;
            if (ip.length() > 0) {
                iadr = InetAddress.getByName(ip);
            } else {
                InetAddress tmp_adr = null;
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                block4: while (nics.hasMoreElements() && iadr == null) {
                    NetworkInterface nic = nics.nextElement();
                    Enumeration<InetAddress> adds = nic.getInetAddresses();
                    while (adds.hasMoreElements()) {
                        InetAddress adr = adds.nextElement();
                        if (!(adr instanceof Inet4Address) || adr.isLoopbackAddress()) continue;
                        tmp_adr = adr;
                        if (!adr.getHostAddress().startsWith("192.168.")) continue;
                        iadr = adr;
                        continue block4;
                    }
                }
                if (iadr == null && tmp_adr != null) {
                    iadr = tmp_adr;
                }
            }
            if (iadr == null) {
                try {
                    iadr = InetAddress.getLocalHost();
                }
                catch (Exception tmp_adr) {
                    // empty catch block
                }
            }
            this.setIpAddress(iadr);
            String bc = config.getString("broadcast", "");
            if (bc.length() != 0) {
                InetAddress badr = InetAddress.getByName(bc);
                this.setBroadcastAddress(badr);
            } else {
                this.setBroadcastAddress(InetAddress.getByAddress(new byte[]{-1, -1, -1, -1}));
            }
        }
        catch (Exception e) {
            this.onStatus(0x4000000);
            throw new NodeRuntimeException(e);
        }
    }

    public void setVender(String vender) {
        this.vender = vender;
    }

    public synchronized void start() {
        if (this.isActive) {
            return;
        }
        this.clearStatus();
        try {
            this.eventExecutor = Executors.newCachedThreadPool();
            this.sendSocket = new DatagramSocket();
            this.sendSocket.setBroadcast(true);
            for (IUecsProtocolHandler protocol : this.protocols) {
                UdpServer server = new UdpServer(protocol);
                server.start();
                this.servers.add(server);
            }
            this.cycleExecutor = Executors.newSingleThreadScheduledExecutor();
            int count = 0;
            for (CcmService ccmsv : this.ccmList) {
                ccmsv.onStart(this);
                long time = ccmsv.getCcm().getLevel().getCycleTime();
                if (time <= 0L) continue;
                this.cycleExecutor.scheduleAtFixedRate(new CycleTask(ccmsv), this.config.getLong(DELAY_TIME, 50L) * (long)count++, time, TimeUnit.MILLISECONDS);
            }
            this.isActive = true;
        }
        catch (Exception e) {
            this.onStatus(0x4000000);
            throw new NodeRuntimeException(e);
        }
    }

    public synchronized void stop() {
        if (!this.isActive) {
            return;
        }
        try {
            for (CcmService ccmsv : this.ccmList) {
                ccmsv.onStop(this);
            }
            if (this.sendSocket != null && !this.sendSocket.isClosed()) {
                this.sendSocket.close();
                this.sendSocket = null;
            }
            this.cycleExecutor.shutdown();
            this.cycleExecutor = null;
            for (UdpServer sv : this.servers) {
                sv.stop();
            }
            this.servers.clear();
            this.isActive = false;
            this.eventExecutor.shutdown();
            this.eventExecutor = null;
        }
        catch (Exception e) {
            throw new NodeRuntimeException(e);
        }
    }

    private class CycleTask
    implements Runnable {
        private CcmService sv;

        private CycleTask(CcmService def) {
            this.sv = def;
        }

        @Override
        public void run() {
            if (this.sv.isEnable()) {
                Ccm ccm = this.sv.getCcm();
                if ('S' == ccm.getSide()) {
                    if (ccm.getNumberValue() != null) {
                        try {
                            DataCcm dccm = this.sv.createDataCcm(ccm);
                            AbstractUecsNode.this.sendPacket(AbstractUecsNode.this.getBroadcastAddress(), dccm.getPort(), dccm.toXmlBytes());
                        }
                        catch (Exception e) {
                            AbstractUecsNode.this.onStatus(0x8000000);
                            throw new NodeRuntimeException(e);
                        }
                    }
                } else if ('R' == ccm.getSide()) {
                    this.sv.checkExpiration();
                }
            }
        }
    }

    private class ReceiveTask
    implements Runnable {
        private IUecsProtocolHandler handler;
        private UecsRequest req;

        private ReceiveTask(IUecsProtocolHandler handler, byte[] data, InetAddress from) {
            this.handler = handler;
            this.req = new UecsRequest(from, handler.getPort(), data, System.currentTimeMillis());
        }

        @Override
        public void run() {
            UecsResponse res = new UecsResponse();
            try {
                this.handler.handle(this.req, res);
                if (res.isValid()) {
                    AbstractUecsNode.this.sendPacket(res.getAddress(), res.getPort(), res.getData());
                }
            }
            catch (Exception e) {
                AbstractUecsNode.this.onStatus(0x100000);
                this.handler.handleException(this.req, res, e);
            }
        }
    }

    private class UdpServer
    implements Runnable {
        private DatagramSocket receiveSocket;
        private Thread thread;
        private IUecsProtocolHandler handler;

        public UdpServer(IUecsProtocolHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[512];
            DatagramPacket packet = new DatagramPacket(buffer, 512);
            while (true) {
                try {
                    while (true) {
                        this.receiveSocket.receive(packet);
                        int start = packet.getOffset();
                        int len = packet.getLength();
                        int i = len - 1;
                        while (i >= 0) {
                            if (buffer[i] == 0) {
                                --len;
                            }
                            --i;
                        }
                        byte[] data = new byte[len];
                        System.arraycopy(buffer, start, data, 0, len);
                        InetAddress address = packet.getAddress();
                        AbstractUecsNode.this.eventExecutor.execute(new ReceiveTask(this.handler, data, address));
                    }
                }
                catch (SocketException e) {
                }
                catch (Exception e) {
                    AbstractUecsNode.this.onStatus(0x100000);
                    continue;
                }
                break;
            }
        }

        public synchronized void start() {
            try {
                this.receiveSocket = new DatagramSocket(this.handler.getPort());
                this.receiveSocket.setReuseAddress(true);
                this.thread = new Thread(this);
                this.thread.start();
            }
            catch (SocketException e) {
                AbstractUecsNode.this.onStatus(0x4000000);
                throw new NodeRuntimeException(e);
            }
        }

        public synchronized void stop() {
            if (this.receiveSocket != null && !this.receiveSocket.isClosed()) {
                this.receiveSocket.close();
            }
            this.receiveSocket = null;
            this.thread = null;
        }
    }
}

