/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.actuator.AbstractCcmListenerAction;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.ISwitcher;

/**
 * 遠隔操作指示CCM（rcM.kNN）による動作を実装したクラスです。
 *
 * @author WaBit
 */
public class RcMListenerAction extends AbstractCcmListenerAction {

    @Override
    public void onStart(ActuatorComponent<?> component) throws Exception {
        execute(component);
    }

    /**
     * rcMで指定された方向(0は停止、正値は正方向動作、負値は逆方法動作)に
     * CCMの有効時間の間動作させます。
     */
    @Override
    public void execute(ActuatorComponent<?> component) throws Exception {
        CcmService ccmSv = component.getActiveRcMService();
        if (ccmSv == null || ccmSv.getCcm() == null) {
            return;
        }
        Ccm rcM = ccmSv.getCcm();
        Number num = rcM.getNumberValue();
        if (component instanceof DigitalPositioningActuator) {
            // 受信CCMの有効時間分動作指示をする
            DigitalPositioningActuator<?> posAct = (DigitalPositioningActuator<?>)component;
            if (num.intValue() > 0) {
                posAct.upPosition(rcM.getLevel().getAvailableTime());
            } else if (num.intValue() < 0){
                posAct.downPosition(rcM.getLevel().getAvailableTime());
            } else {
                posAct.stopPosition();
            }
        } else if (component instanceof IPositioner) {
            IPositioner posAct = (IPositioner)component;
            int pos = posAct.getPosition();
            int npos = pos;
            if (num.intValue() > 0) {
                npos++;
            } else if (num.intValue() < 0){
                npos--;
            }
            if (npos < 0) {
                npos = 0;
            } else if (npos > 100) {
                npos = 100;
            }
            if (pos != npos) {
                component.setValue(npos);
            }
        } else if (component instanceof ISwitcher) {
            // スイッチは単純設定
            component.setValue(num);
        }
    }

}
