/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.db;

import java.io.Serializable;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

/**
 * コンポーネント設定のDBエンティティです。
 *
 * @author WaBit
 *
 */
@DatabaseTable(tableName = "component")
public class ComponentEntity implements Serializable {

    private static final long serialVersionUID = 5337093025429576965L;

    /** カラム名: デバイスID */
    public static final String DEVICE_ID = "dev_id";

    /** カラム名: コンポーネントID */
    public static final String COMPONENT_ID = "compo_id";

    /** カラム名: コンポーネントクラス */
    public static final String COMPONENT_CLASS = "compo_class";

    /** カラム名: コンポーネント名称 */
    public static final String COMPONENT_NAME = "compo_name";

    @DatabaseField(columnName = COMPONENT_ID, id = true, allowGeneratedIdInsert=false)
    private String componentId;

    @DatabaseField(columnName = DEVICE_ID, index = true)
    private String deviceId;

    @DatabaseField(columnName = COMPONENT_CLASS, canBeNull = false)
    private String componentClass;

    @DatabaseField(columnName = COMPONENT_NAME, canBeNull = false)
    private String componentName;

    /**
     * コンポーネント名を取得します。
     * @return コンポーネント名
     */
    public String getComponentName() {
        return componentName;
    }

    /**
     * コンポーネント名を設定します。
     * @param componentName コンポーネント名
     */
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    /**
     * コンポーネントIDを取得します。
     * @return コンポーネントID
     */
    public String getComponentId() {
        return componentId;
    }

    /**
     * コンポーネントIDを設定します。
     * @param componentId コンポーネントID
     */
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    /**
     * デバイスIDを取得します。
     * @return デバイスID
     */
    public String getDeviceId() {
        return deviceId;
    }

    /**
     * デバイスIDを設定します。
     * @param deviceId デバイスID
     */
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * コンポーネントクラスを取得します。
     * @return クラス名
     */
    public String getComponentClass() {
        return componentClass;
    }

    /**
     * コンポーネントクラスを設定します。
     * @param componentClass クラス名
     */
    public void setComponentClass(String componentClass) {
        this.componentClass = componentClass;
    }

}
