/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.top;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

import com.wabit.uecs.ActionMode;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.ISwitcher;
import com.wabit.uecs.pi.device.gpio.GpioActuatorConfig;
import com.wabit.uecs.pi.webui.WebUIApplication;

/**
 * アクチュエータ情報一覧の表示用パネルです。
 *
 * @author WaBit
 */
public class ActuatorsPanel extends Panel {
    private static final long serialVersionUID = -3708813079941308934L;

    /**
     * コンストラクタです。
     * @param id ID
     */
    public ActuatorsPanel(String id) {
        super(id);
        setRenderBodyOnly(true);

        List<ActuatorRow> actList = new ArrayList<ActuatorRow>();
        for (IDevice<?> device : WebUIApplication.getNodeInstance().listDevices()) {
            for (ActuatorComponent<?> actuator : device.listComponents(ActuatorComponent.class)) {
                CcmService oprSv = actuator.getOprServices()[0];
                ActuatorRow rec = new ActuatorRow();
                rec.setName(actuator.getConfig().getString(ComponentConfig.KEY_COMPONENT_NAME));
                if (actuator.getActionMode() == ActionMode.Autonomy) {
                    // 自律モードは細分化
                    String modeName = actuator.getConfig().getString(GpioActuatorConfig.KEY_ACTION_MODE);
                    if (modeName != null) {
                        rec.setMode(actuator.getConfig().getString(GpioActuatorConfig.KEY_ACTION_MODE));
                    } else {
                        rec.setMode(actuator.getActionMode().toString());
                    }
                } else {
                    rec.setMode(actuator.getActionMode().toString());
                }
                if (actuator instanceof ISwitcher) {
                    rec.setValue((actuator.getValue() != null && actuator.getValue().intValue() == 1) ? "ON" : "OFF");
                } else if (actuator instanceof IPositioner) {
                    rec.setValue(((actuator.getValue() != null) ? actuator.getValue() : "") + "[%]");
                } else {
                    // 汎用表示
                    String val = "";
                    if (actuator.getValue() != null) {
                        val += actuator.getValue().toString();
                    }
                    String unit = oprSv.getCcm().getUnit();
                    if (unit != null) {
                        val += "[" + unit + "]";
                    }
                    rec.setValue(val);
                }

                rec.setUpdateTime(new Date(oprSv.getUpdateTime()));
                actList.add(rec);
            }
        }


        add(new ListView<ActuatorRow>("componentList", actList) {
            private static final long serialVersionUID = 1L;

            @Override
            protected void populateItem(ListItem<ActuatorRow> item) {
                item.add(new Label("idx", item.getIndex() + 1));
                item.add(new Label("name", item.getModelObject().getName()));
                item.add(new Label("mode", new ResourceModel(item.getModelObject().getMode())));
                if (item.getModelObject().getValue() != null) {
                    item.add(new Label("value", item.getModelObject().getValue()));
                } else {
                    item.add(new Label("value", "--"));
                }
                if (item.getModelObject().getUpdateTime() != null) {
                    item.add(DateLabel.forDatePattern("updateTime", Model.of(item.getModelObject().getUpdateTime()),
                        "yyyy-MM-dd HH:mm:ss"));
                } else {
                    item.add(new Label("updateTime", "--"));
                }
            }
        });
    }

}
