/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.ccmlist;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.Model;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.ccm.OprCcm;
import com.wabit.uecs.ccm.RcACcm;
import com.wabit.uecs.ccm.RcMCcm;
import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.pi.webui.WebUIApplication;

/**
 * WebUIのCCM一覧画面機能を実装したクラスです。
 *
 * @author WaBit
 *
 */
@AuthorizeInstantiation({ Roles.ADMIN })
public class CcmListPage extends LayoutPage {

    private static final long serialVersionUID = -1845932392057063711L;

    private final List<CcmRow> ccmList = new ArrayList<CcmRow>();

    /** CCM表示名称：機器動作状態CCM（cnd） */
    public static final String CCM_NAME_CND = "ccmName.cnd";
    /** CCM表示名称：制御機器運転状態CCM（opr） */
    public static final String CCM_NAME_OPR = "ccmName.opr";
    /** CCM表示名称：遠隔制御指示CCM（rcA） */
    public static final String CCM_NAME_rcA = "ccmName.rcA";
    /** CCM表示名称：遠隔操作指示CCM（rcM） */
    public static final String CCM_NAME_rcM = "ccmName.rcM";
    /** CCM表示名称：センサー連動受信側 */
    public static final String CCM_NAME_receive = "ccmName.receive";

    @Override
    protected void onInitialize() {
        super.onInitialize();

        StatelessForm<CcmListPage> form = new StatelessForm<CcmListPage>("form") {
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit() {
                setResponsePage(CcmListPage.this.getClass());
            }
        };

        add(form);
        UecsPiNode node = WebUIApplication.getNodeInstance();
        for (CcmService ccmSv : node.listCcmService()) {
            Ccm ccm = ccmSv.getCcm();

            String ccmName = ccmSv.getName();
            if (ccm instanceof RcACcm) {
                ccmName += " [rcA]";
            } else if (ccm instanceof RcMCcm) {
                ccmName += " [rcM]";
            } else if (ccm instanceof OprCcm) {
                ccmName += " [opr]";
            }

            CcmRow rec = new CcmRow();
            rec.setName(ccmName);
            rec.setType(ccm.getType().toString());
            rec.setLevel(ccm.getLevel().toString());
            rec.setRoom(ccm.getRoom());
            rec.setRegion(ccm.getRegion());
            rec.setOrder(ccm.getOrder());
            rec.setUnit(ccm.getUnit());
            rec.setSide(String.valueOf(ccm.getSide()));
            if (ccmSv.isEnable()) {
                rec.setValue(ccm.getStringValue());
                if (ccmSv.getUpdateTime() > Long.MIN_VALUE) {
                    rec.setUpdateTime(new Date(ccmSv.getUpdateTime()));
                    if (ccmSv.isExpired()) {
                        rec.setExpired("X");
                    }
                }
            }
            ccmList.add(rec);
        }

        add(new ListView<CcmRow>("ccmList", ccmList) {
            private static final long serialVersionUID = 1L;

            @Override
            protected void populateItem(ListItem<CcmRow> item) {
                item.add(new Label("idx", item.getIndex() + 1));
                item.add(new Label("name", item.getModelObject().getName()));
                item.add(new Label("type", item.getModelObject().getType()));
                item.add(new Label("level", item.getModelObject().getLevel()));
                item.add(new Label("room", item.getModelObject().getRoom()));
                item.add(new Label("region", item.getModelObject().getRegion()));
                item.add(new Label("order", item.getModelObject().getOrder()));
                if (item.getModelObject().getValue() != null) {
                    item.add(new Label("value", item.getModelObject().getValue()));
                } else {
                    item.add(new Label("value", "--"));
                }
                item.add(new Label("unit", item.getModelObject().getUnit()));
                item.add(new Label("side", item.getModelObject().getSide()));
                if (item.getModelObject().getUpdateTime() != null) {
                    item.add(DateLabel.forDatePattern("updateTime", Model.of(item.getModelObject().getUpdateTime()),
                            "yyyy-MM-dd HH:mm:ss"));
                } else {
                    item.add(new Label("updateTime", "--"));
                }
                item.add(new Label("expired", item.getModelObject().getExpired()));
            }
        });

    }

}
