/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import org.apache.wicket.Session;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.request.Request;

import com.wabit.uecs.pi.UecsPiNodeConfig;

/**
 * Wicketの認証処理を実装したクラスです。
 *
 * @author WaBit
 *
 */
public class AuthSession extends AuthenticatedWebSession {

    /**
     * コンストラクタです。
     * @param request HTTPリクエスト
     */
    public AuthSession(Request request) {
        super(request);
    }

    private static final long serialVersionUID = 4954229590068698459L;

    /**
     * ユーザー名とパスワードで認証処理を行います。
     */
    @Override
    public boolean authenticate(String username, String inputPassword) {

        UecsPiNodeConfig conf = (UecsPiNodeConfig) WebUIApplication.getNodeInstance().getConfig();
        String password = conf.getString(UecsPiNodeConfig.KEY_ADMIN_PASSWORD);

        if (inputPassword != null && password.equals(inputPassword)) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public Roles getRoles() {
        Roles roles = new Roles();
        if (isSignedIn()) {
            roles.add(Roles.ADMIN);
        }
        return roles;
    }

    /**
     * 現在のセッションを取得します。
     * @return セッション
     */
    public static AuthSession get() {
        return (AuthSession) Session.get();
    }

    @Override
    public void signOut() {
        super.signOut();
    }
}
