/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.serial;


/**
 * シリアル通信クライアントのインターフェースです。
 *
 * @author WaBit
 */
public interface ISerialPortClient {

    /**
     * 初期化処理を行います。
     * @param conf 設定値
     * @throws Exception 処理に失敗した場合にスローされます。
     */
    public void init(SerialPortDeviceConfig conf) throws Exception;

    /**
     * 通信ポートを開きます。
     *
     * @throws Exception 処理に失敗した場合にスローされます。
     */
    public void open() throws Exception;

    /**
     * 通信ポートを閉じます。
     *
     * @throws Exception 処理に失敗した場合にスローされます。
     */
    public void close() throws Exception;

    /**
     * データを送信します。
     *
     * @param data データ配列
     * @throws Exception 処理に失敗した場合にスローされます。
     */
    public void sendData(byte[] data) throws Exception;

    /**
     * データ受信リスナーを登録します。
     *
     * @param lsn リスナー
     */
    public void addListener(ISerialPortListener lsn);

    /**
     * データ受信リスナーを削除します。
     * @param lsn 削除対象リスナー
     * @return 削除に成功した場合true
     */
    public boolean removeListener(ISerialPortListener lsn);
}
