/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.i2c;

import java.util.concurrent.TimeUnit;

import com.pi4j.io.i2c.I2CDevice;
import com.wabit.uecs.pi.device.PiSensorBase;

/**
 * I2C接続されたデバイス内で動作するセンサーコンポーネントクラスです。
 *
 * @author WaBit
 *
 * @param <T> 設定値クラス
 */
public class I2cSensorBase<T extends I2cSensorConfig> extends PiSensorBase<T> implements I2cReader {


    /**
     * コンストラクタです。
     * @param id コンポーネントID
     * @param config 設定値クラス
     */
    public I2cSensorBase(String id, T config) {
        super(id, config);
    }

    /**
     * センサー値取得スレッドを起動します。
     */
    @Override
    protected void onStart() throws Exception {
        int period = getConfig().getInt(I2cSensorConfig.KEY_SENSE_INTERVAL);
        if (period > 0) {
            ((I2cDeviceBase<?>)getDevice()).addI2cReaderTask(this, period, TimeUnit.SECONDS);
        }

    }

    /**
     * デフォルトは空実装です。
     */
    @Override
    protected void onStop() throws Exception {

    }

    /**
     * デフォルトは空実装です。
     */
    @Override
    public void onReadProcess(I2CDevice i2cDevice) throws Exception {

    }

    /**
     * 読み込み失敗時には、センサー値をnullに設定します。
     */
    @Override
    public void onReadError(Exception e) {
        setValue(null);
    }


}
