/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.i2c;

import com.pi4j.io.i2c.I2CDevice;

/**
 * 定期実行されるI2C接続データ読み込み処理を行うインタフェースです。
 *
 * @author WaBit
 *
 */
public interface I2cReader {

    /**
     * センサー値取得処理を実装します。
     * KEY_SENSE_INTERVALで設定された時間間隔で起動されます。
     *
     * @param i2cDevice 取得対象デバイス
     * @throws Exception 取得に失敗した場合スローします。
     */
    void onReadProcess(I2CDevice i2cDevice) throws Exception;

    /**
     * 読み込み失敗した場合の処理を実装します。
     * @param e 失敗時に発生した例外
     */
    void onReadError(Exception e);

}
