/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.pi.device.IPositioner;

/**
 * 固定位置を設定するアクション実装です。
 *
 * @author WaBit
 */
public class FixedPositioningAction implements IActuatorAction {

    private int targetPosition;

    @Override
    public void onStart(ActuatorComponent<?> component) throws Exception {
        IPositioner posAct = (IPositioner)component;
        posAct.setPosition(targetPosition);
    }

    @Override
    public void onStop(ActuatorComponent<?> component) throws Exception {
    }

    @Override
    public void execute(ActuatorComponent<?> component) throws Exception {
        IPositioner posAct = (IPositioner)component;
        if (posAct.getPosition() != targetPosition) {
            posAct.setPosition(targetPosition);
        }
    }

    /**
     * 固定位置を取得します。
     * @return 位置情報(0-100)
     */
    public int getPosition() {
        return targetPosition;
    }

    /**
     * 固定位置設定します。
     * @param targetPosition 位置情報(0-100)
     */
    public void setPosition(int targetPosition) {
        this.targetPosition = targetPosition;
    }

}
