/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IComponentListener;
import com.wabit.uecs.device.controller.ControllerComponent;

/**
 * コントローラ共通の基底実装クラスです。
 *
 * @author WaBit
 */
public abstract class PiControllerBase<T extends PiControllerConfig> extends ControllerComponent<T> {

    // ロガー
    private Log logger = LogFactory.getLog(getClass());

    /**
     * コンストラクタです。
     * @param id コンポーネントID
     * @param config 設定値
     */
    public PiControllerBase(String id, T config) {
        super(id, config);
        addListener(new ContollerListener());
    }

    /*
     * 内部動作リスナー（ログ記録用）
     *
     */
    private class ContollerListener implements IComponentListener {

        @Override
        public void componentStarted(IComponent<?> component) {
            if (logger.isDebugEnabled()) {
                logger.debug("ID=" + component.getId());
            }
        }

        @Override
        public void componentStopped(IComponent<?> component) {
            if (logger.isDebugEnabled()) {
                logger.debug("ID=" + component.getId());
            }
        }

        @Override
        public void componentValueUpdated(IComponent<?> component) {
            if (logger.isDebugEnabled()) {
                logger.debug("ID=" +  component.getId() + ", value=" + component.getValue());
            }
            if (component != this) {
                return;
            }
        }

        @Override
        public void handleComponentException(IComponent<?> component, Exception e) {
            logger.error("ID=" + component.getId(), e);
        }
    }

}
