package myapp;

import java.util.concurrent.Callable;

import myapp.device.sample1.DummyDevice;
import myapp.device.sample1.DummySensor;
import myapp.device.sample2.SimpleGpioDevice;
import myapp.device.sample2.TimerSwitchActuator;
import myapp.device.sample3.RegexSensor;
import myapp.device.sample3.SimpleSerialDevice;
import myapp.device.sample4.I2cCo2Sensor;
import myapp.device.sample4.SimpleI2cDevice;

import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;

public class MyPiNode extends UecsPiNode {

    public MyPiNode() {
        super(new MyPiNodeConfig());
    }

    protected void installProcess() throws Exception {

        DatabaseManager.callInTransaction(new Callable<Void>() {
            public Void call() throws Exception {

                // Sample 1
                DummyDevice dummyDevice = new DummyDevice(DatabaseUtils.nextDeviceId());
                DummySensor dummySensor = new DummySensor(DatabaseUtils.nextComponentId());
                dummyDevice.addComponent(dummySensor);
                DatabaseUtils.saveDevice(dummyDevice);

                // Sample 2
                SimpleGpioDevice gpioDevice = new SimpleGpioDevice(DatabaseUtils.nextDeviceId());
                TimerSwitchActuator timerSwitch = new TimerSwitchActuator(
                        DatabaseUtils.nextComponentId());
                gpioDevice.addComponent(timerSwitch);
                DatabaseUtils.saveDevice(gpioDevice);

                // Sample 3
                SimpleSerialDevice serialDevice = new SimpleSerialDevice(DatabaseUtils.nextDeviceId());
                RegexSensor regexSensor = new RegexSensor(DatabaseUtils.nextComponentId());
                serialDevice.addComponent(regexSensor);
                DatabaseUtils.saveDevice(serialDevice);

                // Sample 4
                SimpleI2cDevice i2cDevice = new SimpleI2cDevice(DatabaseUtils.nextDeviceId());
                I2cCo2Sensor co2Sensor = new I2cCo2Sensor(DatabaseUtils.nextComponentId());
                i2cDevice.addComponent(co2Sensor);
                DatabaseUtils.saveDevice(i2cDevice);

                return null;
            }

        });

    }

}
