package myapp.webui.sample1;

import java.util.Arrays;
import java.util.concurrent.Callable;

import myapp.MyPiNode;
import myapp.device.sample1.DummyDevice;
import myapp.device.sample1.DummySensor;
import myapp.device.sample1.DummySensorConfig;
import myapp.webui.MyUIApplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;

import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.util.MessageCode;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.util.PropertyConfig;

@AuthorizeInstantiation({Roles.ADMIN})
public class DummyDevicePage extends LayoutPage {
    private static final long serialVersionUID = 9205561784306869639L;

    private Form<PropertyConfig> deviceForm;
    private PropertyConfig formParams = new PropertyConfig();

    private Log logger = LogFactory.getLog(getClass());

    private static String[] ccmLevels = new String[] {
            CcmLevel.A_1S_0.toString(),
            CcmLevel.A_1S_1.toString(),
            CcmLevel.A_10S_0.toString(),
            CcmLevel.A_10S_1.toString(),
            CcmLevel.A_1M_0.toString(),
            CcmLevel.A_1M_1.toString(),
            CcmLevel.B_0.toString(),
            CcmLevel.B_1.toString(),
    };

    private String deviceId;
    private String componentId;

    public DummyDevicePage() {
    }

    public DummyDevicePage(IModel<?> settingsModel) {
        super(settingsModel);
    }

    public DummyDevicePage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();

        // 設定対象となるデバイスとコンポーネントのIDを取得します。
        MyPiNode node = (MyPiNode)MyUIApplication.getNodeInstance();
        DummyDevice device = node.listDevices(DummyDevice.class).get(0);
        DummySensor sensor = device.listComponents(DummySensor.class).get(0);
        deviceId = device.getId();
        componentId = sensor.getId();

        // コンポーネント設定値をWebUIフォームの初期値としてコピーします
        formParams.putAll(sensor.getConfig());

        deviceForm = new Form<PropertyConfig>("deviceForm") {
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit() {
                try {
                    deviceForm.modelChanging();

                    // フォーム入力された設定値をセンサー設定に反映して
                    // DBに保存したのち、ノードを再起動します。
                    DatabaseManager.callInTransaction(new Callable<Void>() {
                        public Void call() throws Exception {
                            DummySensor sensor = (DummySensor)MyUIApplication.getNodeInstance().getDevice(deviceId)
                                    .getComponent(componentId);
                            sensor.getConfig().putAll(formParams);
                            DatabaseUtils.saveComponent(deviceId, sensor);
                            MyUIApplication.getNodeInstance().restart();
                            return null;
                        }
                    });

                    deviceForm.modelChanged();
                    success(MessageUtils.getMessage(MessageCode.SAVED));
                } catch (Exception e) {
                    error(MessageUtils.getMessage(MessageCode.ERROR));
                    logger.error("save error.", e);
                }
            }
        };

        // フォームに入力フィールドを登録します。
        deviceForm.setDefaultModel(new CompoundPropertyModel<PropertyConfig>(formParams));
        deviceForm
                .add(new RequiredTextField<String>(DummySensorConfig.KEY_COMPONENT_NAME, String.class)
                        .add(new StringValidator(1, 50)));
        deviceForm.add(new RequiredTextField<String>(DummySensorConfig.KEY_CCM_INFO_NAME, String.class)
                .add(new StringValidator(1, 15)));
        deviceForm.add(new TextField<String>(DummySensorConfig.KEY_CCM_NODE_TYPE, String.class)
                .setConvertEmptyInputStringToNull(false).add(
                        new StringValidator(0, 3)));
        deviceForm.add(new TextField<String>(DummySensorConfig.KEY_CCM_UNIT, String.class)
                .setConvertEmptyInputStringToNull(false).add(
                        new StringValidator(0, 10)));
        deviceForm.add(new TextField<Integer>(DummySensorConfig.KEY_CCM_CAST, Integer.class));
        deviceForm.add(new DropDownChoice<String>(DummySensorConfig.KEY_CCM_LEVEL, Arrays
                .asList(ccmLevels)));
        deviceForm.add(new RequiredTextField<Integer>(DummySensorConfig.KEY_CCM_ROOM, Integer.class)
                .add(new RangeValidator<Integer>(0, 127)));
        deviceForm.add(new RequiredTextField<Integer>(DummySensorConfig.KEY_CCM_REGION, Integer.class)
                .add(new RangeValidator<Integer>(0, 127)));
        deviceForm.add(new RequiredTextField<Integer>(DummySensorConfig.KEY_CCM_ORDER, Integer.class)
                .add(new RangeValidator<Integer>(0, 3000)));
        deviceForm
                .add(new RequiredTextField<Integer>(DummySensorConfig.KEY_CCM_PRIORITY, Integer.class)
                        .add(new RangeValidator<Integer>(0, 29)));
        deviceForm.add(new TextField<Float>(DummySensorConfig.KEY_SENSE_VALUE, Float.class));
        add(deviceForm);

    }


}
