#!/bin/sh

ip=$1
netmask=$2
gateway=$3
dns=$4

file=/opt/scripts/dhcpcd_template_static

file1=/opt/scripts/dhcpcd_template_static.1
file2=/opt/scripts/dhcpcd_template_static.2
file3=/opt/scripts/dhcpcd_template_static.3
file4=/opt/scripts/dhcpcd_template_static.4
target_file=/etc/dhcpcd.conf

sed -e "s/_IP_/${ip}/g" $file > $file1
sed -e "s/_NETMASK_/${netmask}/g" $file1 > $file2
if [ -z "${gateway}" ]; then
  sed -e "s/_GATEWAY_/${gateway}/g" $file2 > $file3
else
  sed -e "s/_GATEWAY_/static routers=${gateway}/g" $file2 > $file3
fi
if [ -z "${dns}" ]; then
  sed -e "s/_DNS_/${dns}/g" $file3 > $file4
else
  sed -e "s/_DNS_/static domain_name_servers=${dns}/g" $file3 > $file4
fi

mv $file4 $target_file
rm -f $file1
rm -f $file2
rm -f $file3

sleep 3s

/sbin/reboot
