/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.signin;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.CompoundPropertyModel;

import com.wabit.uecs.pi.util.MessageCode;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.AuthSession;
import com.wabit.uecs.pi.webui.LayoutPage;

/**
 * WebUIのログイン画面機能を実装したクラスです。
 *
 * @author WaBit
 */
public class SignInPage extends LayoutPage {

    private static final long serialVersionUID = -2965431487611693402L;

    private String password;

    private String loginStatus;

    /**
     * コンストラクタです。
     * メニュー表示をしないように設定しています。
     */
    public SignInPage() {
        getMenuPanel().setVisible(false);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();

        StatelessForm<SignInPage> form = new StatelessForm<SignInPage>("form") {
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit() {
                boolean authResult = AuthSession.get().signIn(null, password);
                if (authResult) {
                    setResponsePage(getApplication().getHomePage());
                } else {
                    loginStatus = MessageUtils.getMessage(MessageCode.LOGIN_FAILED);
                }
            }

        };

        form.setDefaultModel(new CompoundPropertyModel<SignInPage>(this));
        form.add(new PasswordTextField("password"));
        form.add(new Label("loginStatus"));
        add(form);
    }
}
