/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

/**
 * 画面全体のレイアウトを定義したページクラスです。
 *
 * @author WaBit
 */
public class LayoutPage extends WebPage {

    private static final long serialVersionUID = 3225204194923790251L;

    private Component headerPanel;

    private Component menuPanel;

    private Component footerPanel;

    private Component feedbackPanel;

    /**
     * コンストラクタです。
     */
    public LayoutPage() {
        initCommon();
    }

    /**
     * コンストラクタです。
     * @param settingsModel データモデル
     */
    public LayoutPage(IModel<?> settingsModel) {
        super(settingsModel);
        initCommon();
    }

    /**
     * コンストラクタです。
     * @param parameters ページパラメータ
     */
    public LayoutPage(PageParameters parameters) {
        super(parameters);
        initCommon();
    }

    /*
     * 共通初期化処理
     */
    private void initCommon() {
        WebUIApplication appl = (WebUIApplication) getApplication();
        // 各パーツページを作成
        try {
            setHeaderPanel(appl.getHeaderPanelClass().getConstructor(String.class).newInstance("headerPanel"));
            setMenuPanel(appl.getMenuPanelClass().getConstructor(String.class).newInstance("menuPanel"));
            setFooterPanel(appl.getFooterPanelClass().getConstructor(String.class).newInstance("footerPanel"));
            setFeedbackPanel(appl.getFeedbackPanelClass().getConstructor(String.class).newInstance("feedbackPanel"));
            add(getHeaderPanel());
            add(getMenuPanel());
            add(getFooterPanel());
            add(getFeedbackPanel());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * ヘッダー部分表示コンポーネントを取得します。
     * @return パネルコンポーネント
     */
    public Component getHeaderPanel() {
        return headerPanel;
    }

    /**
     * メニュー部分表示コンポーネントを取得します。
     * @return パネルコンポーネント
     */
    public Component getMenuPanel() {
        return menuPanel;
    }

    /**
     * フッター部分表示コンポーネントを取得します。
     * @return パネルコンポーネント
     */
    public Component getFooterPanel() {
        return footerPanel;
    }

    /**
     * メッセージ表示コンポーネントを取得します。
     * @return パネルコンポーネント
     */
    public Component getFeedbackPanel() {
        return feedbackPanel;
    }

    /**
     * ヘッダー部分表示コンポーネントを設定します。
     * @param headerPanel パネルコンポーネント
     */
    public void setHeaderPanel(Component headerPanel) {
        this.headerPanel = headerPanel;
    }

    /**
     * メニュー部分表示コンポーネントを設定します。
     * @param menuPanel パネルコンポーネント
     */
    public void setMenuPanel(Component menuPanel) {
        this.menuPanel = menuPanel;
    }

    /**
     * フッター部分表示コンポーネントを設定します。
     * @param footerPanel パネルコンポーネント
     */
    public void setFooterPanel(Component footerPanel) {
        this.footerPanel = footerPanel;
    }

    /**
     * メッセージ表示コンポーネントを設定します。
     * @param feedbackPanel パネルコンポーネント
     */
    public void setFeedbackPanel(Component feedbackPanel) {
        this.feedbackPanel = feedbackPanel;
    }

}
