/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.serial;

import com.wabit.uecs.pi.device.PiDeviceConfig;
import com.wabit.uecs.pi.webui.WebUIApplication;

/**
 * シリアル通信制御デバイスの設定値クラスです。
 *
 * @author WaBit
 */
public class SerialPortDeviceConfig extends PiDeviceConfig {

    private static final long serialVersionUID = 7722862925847342308L;

    /** 設定項目キー : シリアルポートID */
    public static final String KEY_SERIAL_PORT_ID = "SerialPortId";
    /** 設定項目キー : 通信スピード(BPS) */
    public static final String KEY_SERIAL_PORT_SPEED = "SerialPortSpeed";
    /** 設定項目キー : 通信クライアント実装クラス */
    public static final String KEY_SERIAL_PORT_CLIENT_CLASS = "SerialPortClientClass";

    /**
     * デフォルトコンストラクタです。
     */
    public SerialPortDeviceConfig() {

        // 動作モードで接続方式を変更
        if (WebUIApplication.getNodeInstance().isDevelopmentMode()) {
            // 開発モードの場合はモック実装を利用
            setString(KEY_SERIAL_PORT_CLIENT_CLASS, SerialPortClientMockImpl.class.getName());
        } else {
            // デプロイモードの場合はPi4Jのシリアル接続
            setString(KEY_SERIAL_PORT_CLIENT_CLASS, SerialPortClientPi4jImpl.class.getName());
        }

        setString(KEY_SERIAL_PORT_ID, "/dev/ttyS0");
        setInt(KEY_SERIAL_PORT_SPEED, 9600);
    }
}
