/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.serial;

import java.util.HashSet;
import java.util.Set;

/**
 * シリアル通信クライアントの共通実装クラスです。
 * @author WaBit
 *
 */
public abstract class SerialPortClientBase implements ISerialPortClient {

    private Set<ISerialPortListener> listeners = new HashSet<ISerialPortListener>();


    @Override
    public synchronized void addListener(ISerialPortListener lsn) {
        listeners.add(lsn);
    }

    @Override
    public synchronized boolean removeListener(ISerialPortListener lsn) {
        return listeners.remove(lsn);
    }

    /**
     * データ受信イベント処理を行います。
     * リスナーに対してデータ受信メソッドを起動します。
     * @param data 受信データ
     */
    protected void fireDataAvailableEvent(byte[] data) {
        for (ISerialPortListener lsn : listeners) {
            lsn.dataReceived(data);
        }
    }

}
