/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

/**
 * 位置制御アクチュエータの設定値クラスです。
 *
 * @author WaBit
 */
public class DigitalPositioningActuatorConfig extends GpioActuatorConfig {

    private static final long serialVersionUID = 1L;

    /** 設定項目キー : GPIOピン番号(正方向入力) */
    public static final String KEY_GPIO_PIN_UP_IN = "GpioPinUpIn";
    /** 設定項目キー : GPIOピン番号(正方向出力) */
    public static final String KEY_GPIO_PIN_UP_OUT = "GpioPinUpOut";
    /** 設定項目キー : GPIOピン番号(負方向入力) */
    public static final String KEY_GPIO_PIN_DOWN_IN = "GpioPinDownIn";
    /** 設定項目キー : GPIOピン番号(負方向出力) */
    public static final String KEY_GPIO_PIN_DOWN_OUT = "GpioPinDownOut";
    /** 設定項目キー : 最大位置までの動作時間 */
    public static final String KEY_MAX_POSITION_TIME = "MaxPositionTime";
    /** 設定項目キー : ギャップ補正処理フラグ */
    public static final String KEY_GAP_CORRECTION = "GapCorrection";

    public DigitalPositioningActuatorConfig() {
        // デフォルト値
        setInt(KEY_MAX_POSITION_TIME, 0);
    }

}
