/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi;

import java.util.Arrays;
import java.util.List;

import com.wabit.uecs.NodeConfig;
import com.wabit.uecs.UecsConstants;

/**
 * UECS-Piノードに関連する設定値クラスです。
 * @author WaBit
 */
public class UecsPiNodeConfig extends NodeConfig {
    private static final long serialVersionUID = 1L;
    // UECSID
    private static final String DEFAULT_UECS_ID = "011001001000";
    // VENDER
    private static final String DEFAULT_VENDER = "Anonymous";
    // NAME
    private static final String DEFAULT_NODE_NAME = "UECS-Pi";

    /** 設定値キー：IP種別 */
    public static final String KEY_NODE_IP_TYPE = "IpType";
    /** 設定値キー：サブネットマスク */
    public static final String KEY_NODE_IP_MASK = "IpMask";
    /** 設定値キー：デフォルトゲートウェイ */
    public static final String KEY_NODE_IP_GATEWAY = "IpGateway";
    /** 設定値キー：DNSサーバー */
    public static final String KEY_NODE_DNS_SERVER = "DnsServer";
    /** 設定値キー：管理パスワード */
    public static final String KEY_ADMIN_PASSWORD = "AdminPassword";
    /** 設定値キー：Date/TimeCCMでの補正フラグ */
    public static final String KEY_RECEIVE_DATETIME = "ReceiveDatetime";
    /** 設定値キー：Date/TimeCCMの送信フラグ */
    public static final String KEY_SEND_DATETIME = "SendDatetime";
    /** 設定値キー：動作ボード種別 */
    public static final String KEY_RASPI_MODEL = "RaspiModel";
    /** 設定値キー：ファームウェアバージョン */
    public static final String KEY_FIRMWARE_VERSION = "FirmwareVersion";
    /** 設定値キー：表示ロケール */
    public static final String KEY_LOCALE = "Locale";
    /** 設定値キー：タイムゾーン */
    public static final String KEY_TIME_ZONE = "TimeZone";

    private static final String[]  fixKeys = new String[] {
        KEY_UECS_ID,
        KEY_UECS_VERSION,
        KEY_VENDER,
        KEY_NODE_MAC,
        KEY_NODE_IP_TYPE,
        KEY_NODE_IP,
        KEY_NODE_BROADCAST,
        KEY_NODE_IP_GATEWAY,
        KEY_NODE_IP_MASK,
        KEY_NODE_DNS_SERVER,
        KEY_FIRMWARE_VERSION,
        KEY_ADMIN_PASSWORD,
    };

    /**
     * デフォルト値を設定したインスタンスを返します。
     */
    public UecsPiNodeConfig() {
        setString(KEY_NODE_NAME, DEFAULT_NODE_NAME);
        setString(KEY_NODE_IP_TYPE, AppConstants.IP_TYPE_DHCP);
        setString(KEY_NODE_IP_MASK, "255.255.255.0");
        setString(KEY_VENDER, DEFAULT_VENDER);
        setString(KEY_UECS_ID, DEFAULT_UECS_ID);
        setString(KEY_UECS_VERSION, UecsConstants.DEFAULT_VERSION);
        setString(KEY_ADMIN_PASSWORD, "admin");
        setString(KEY_NODE_TYPE, "cMC");
        setInt(KEY_NODE_ROOM, 1);
        setInt(KEY_NODE_REGION, 1);
        setInt(KEY_NODE_ORDER, 1);
        setInt(KEY_NODE_PRIORITY, 1);
        setString(KEY_RASPI_MODEL, AppConstants.RASPI_MODEL_B);
    }

    /**
     * 設定ファイル読込などで書換不可としたい項目キーを取得します。
     * @return
     */
    public List<String> getFixKeys() {
        return Arrays.asList(fixKeys);
    }

}
