package myapp.device.sample4;

import com.pi4j.io.i2c.I2CDevice;
import com.wabit.uecs.pi.device.i2c.I2cSensorBase;
import com.wabit.uecs.pi.device.i2c.I2cUtils;

public class I2cCo2Sensor extends I2cSensorBase<I2cCo2SensorConfig> {

    private static final byte GET_CO2_DATA = (byte) 0x05;

    private byte[] buffer = new byte[2];

    public I2cCo2Sensor(String id) {
        super(id, new I2cCo2SensorConfig());
    }

    @Override
    public void onReadProcess(I2CDevice i2cDevice) throws Exception {

        I2cUtils.write(i2cDevice, 2, GET_CO2_DATA);
        int len = I2cUtils.read(i2cDevice, 100L, buffer, 0, 2);
        if (len >= 2) {
            int co2 = (buffer[0] & 0xff) * 256 + (buffer[1] & 0xff);
            setValue(co2);
        }

    }

}
