/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.protocol;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import com.wabit.uecs.CcmID;
import com.wabit.uecs.UecsConstants;

/**
 * データ要求CCMクラスです。
 * @author WaBit
 *
 */
public class RequestCcm extends XmlCcm {

    /** REQUESTタグ名 */
    public static final String TAG_REQUEST = "REQUEST";

    @Override
    void appendXml(StringBuilder sb) {
        sb.append("<").append(TAG_REQUEST);
        if (getType() != null) {
            sb.append(" ").append(ATTR_TYPE).append("=\"")
                    .append(escape(getType())).append("\"");
        }
        if (getRoom() > -1) {
            sb.append(" ").append(ATTR_ROOM).append("=\"")
                    .append(getRoom()).append("\"");
        }
        if (getRegion() > -1) {
            sb.append(" ").append(ATTR_REGION).append("=\"")
                    .append(getRegion()).append("\"");
        }
        if (getOrder() > -1) {
            sb.append(" ").append(ATTR_ORDER).append("=\"")
                    .append(getOrder()).append("\"");
        }
        sb.append("/>");
    }

    @Override
    void importXml(Document doc) throws Exception {
        Element elm = (Element) doc.getElementsByTagName(TAG_REQUEST).item(0);
        String val = elm.getAttribute(ATTR_TYPE);
        if (val.length() != 0) {
            setType(new CcmID(val));
        }
        val = elm.getAttribute(ATTR_ROOM);
        if (val.length() != 0) {
            setRoom(Integer.parseInt(val));
        } else {
            setRoom(0);
        }
        val = elm.getAttribute(ATTR_REGION);
        if (val.length() != 0) {
            setRegion(Integer.parseInt(val));
        } else {
            setRegion(0);
        }
        val = elm.getAttribute(ATTR_ORDER);
        if (val.length() != 0) {
            setOrder(Integer.parseInt(val));
        } else {
            setOrder(0);
        }

    }

    @Override
    public int getPort() {
        return UecsConstants.DATA_PORT;
    }

    @Override
    void setXmlAttributes(String tagName, Attributes attributes) {
        if (TAG_REQUEST.equals(tagName)) {
            String val = attributes.getValue(ATTR_TYPE);
            if (val.length() != 0) {
                setType(new CcmID(val));
            }
            val = attributes.getValue(ATTR_ROOM);
            if (val.length() != 0) {
                setRoom(Integer.parseInt(val));
            } else {
                setRoom(0);
            }
            val = attributes.getValue(ATTR_REGION);
            if (val.length() != 0) {
                setRegion(Integer.parseInt(val));
            } else {
                setRegion(0);
            }
            val = attributes.getValue(ATTR_ORDER);
            if (val.length() != 0) {
                setOrder(Integer.parseInt(val));
            } else {
                setOrder(0);
            }
        }

    }

    @Override
    void setXmlValue(String tagName, String value) {

    }

}
