/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.device.actuator;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;

/**
 * CCMの変化に連動したアクションのインタフェースです。
 * @author WaBit
 */
public interface ICcmListenerAction extends IActuatorAction {

    /**
     * 連動対象となるCCMサービスを追加します。
     * @param ccmServices 連動対象となるCCM一覧
     */
    public void addCcmService(CcmService... ccmServices);

    /**
     * 対象となるCCM一覧を取得します。
     * @return CCM一覧
     */
    public CcmService[] getCcmServices();

    /**
     * 動作対象となるCCMかを判定します。
     * @param ccm 検査するCCM
     * @return 対象として登録されていればtrue
     */
    public boolean isAccepted(Ccm ccm);

    /**
     * 対象CCMが有効期限切れであるかを判定します。
     * @return 有効期限切れであればtrue
     */
    public boolean isExpired();
}
