/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.protocol;

/**
 * CCM解析例外クラスです。
 * @author WaBit
 *
 */
public class CcmParserException extends Exception {
    private static final long serialVersionUID = 1L;

    private String ccmMessage;

    /**
     * コンストラクタ.
     * @param message 例外メッセージ
     * @param th 発生元
     * @param ccmMessage 解析対象CCMデータ文字列
     */
    public CcmParserException(String message, Throwable th, String ccmMessage) {
        super(message, th);
        this.ccmMessage = ccmMessage;
    }

    /**
     * 解析対象CCMデータ文字列を取得します。
     * @return 解析対象CCMデータ文字列
     */
    public String getCcmMessage() {
        return this.ccmMessage;
    }
}
