/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.device.actuator;


/**
 * アクチュエータ動作時に呼ばれる処理を定義するインタフェースです。
 *
 * @author WaBit
 */
public interface IActuatorAction {

    /**
     * コンポーネントstart時に呼び出されます。
     * 主に初期化処理を実装します。
     * @param component コンポーネント
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void onStart(ActuatorComponent<?> component) throws Exception;

    /**
     * コンポーネントstop時に呼び出されます。
     * 主に終了処理を実装します。
     * @param component コンポーネント
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void onStop(ActuatorComponent<?> component) throws Exception;

    /**
     * アクション実行します。
     * @param component コンポーネント
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void execute(ActuatorComponent<?> component) throws Exception;


}
