/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.device.actuator;

import java.util.HashSet;
import java.util.Set;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;

/**
 * CCMの値変化に連動するアクションの基底クラスです。
 *
 * @author WaBit
 */
public abstract class AbstractCcmListenerAction implements ICcmListenerAction {

    private Set<CcmService> ccmServices = new HashSet<CcmService>();

    /**
     * コンストラクタ。
     */
    public AbstractCcmListenerAction() {

    }

    /**
     * コンストラクタ。
     * @param ccmServices 連動対象となるCCMのリスト
     */
    public AbstractCcmListenerAction(CcmService... ccmServices) {
        addCcmService(ccmServices);
    }

    @Override
    public void addCcmService(CcmService... ccmServices) {
        for (CcmService ccmSv : ccmServices) {
            if (ccmSv != null) {
                this.ccmServices.add(ccmSv);
            }
        }
    }

    @Override
    public CcmService[] getCcmServices() {
        return ccmServices.toArray(new CcmService[ccmServices.size()]);
    }

    @Override
    public void onStart(ActuatorComponent<?> component) throws Exception {

    }

    @Override
    public void onStop(ActuatorComponent<?> component) throws Exception {
    }

    @Override
    public boolean isAccepted(Ccm ccm) {
        for (CcmService ccmSv : ccmServices) {
            if (ccmSv != null && ccmSv.getCcm().equals(ccm)) {
                return true;
            }
        }
        return false;
    }

    /**
     *  すべてが期限切れの場合にtrueを返します。
     */
    @Override
    public boolean isExpired() {
        for (CcmService ccmSv : ccmServices) {
            if (ccmSv != null && !ccmSv.isExpired()) {
                return false;
            }
        }
        return true;
    }

}
