/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.device;

/**
 * デバイス動作リスナーです。
 *
 * @author WaBit
 */
public interface IDeviceListener {

    /**
     * デバイスが起動された場合に起動されます。
     * @param device デバイスインスタンス
     */
    public void deviceStarted(IDevice<?> device);

    /**
     * デバイスが停止された場合に起動されます。
     * @param device デバイスインスタンス
     */
    public void deviceStopped(IDevice<?> device);

    /**
     * 動作中に例外が発生した場合に起動されます。
     * @param device デバイスインスタンス
     * @param e 発生した例外
     */
    public void handleDeviceException(IDevice<?> device, Exception e);
}
