/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.device;

import com.wabit.uecs.util.PropertyConfig;

/**
 * コンポーネント設定情報クラスです。
 *
 * @author WaBit
 */
public class ComponentConfig extends PropertyConfig {

    public static final long serialVersionUID = 1L;

    /** 設定項目キー : 機器名称 */
    public static final String KEY_COMPONENT_NAME = "ComponentName";
    /** 設定項目キー : CCM項目名 */
    public static final String KEY_CCM_INFO_NAME = "CcmInfoName";
    /** 設定項目キー : ノード種別(kNN) */
    public static final String KEY_CCM_NODE_TYPE = "CcmNodeType";
    /** 設定項目キー : CCM属性値:送受信level */
    public static final String KEY_CCM_LEVEL = "CcmLevel";
    /** 設定項目キー : CCM属性値:送受信サイド */
    public static final String KEY_CCM_SIDE = "CcmSide";
    /** 設定項目キー : CCM属性値:room */
    public static final String KEY_CCM_ROOM = "CcmRoom";
    /** 設定項目キー : CCM属性値:region */
    public static final String KEY_CCM_REGION = "CcmRegion";
    /** 設定項目キー : CCM属性値:order */
    public static final String KEY_CCM_ORDER = "CcmOrder";
    /** 設定項目キー : CCM属性値:priority */
    public static final String KEY_CCM_PRIORITY = "CcmPriority";
    /** 設定項目キー : CCM属性値:cast */
    public static final String KEY_CCM_CAST = "CcmCast";
    /** 設定項目キー : CCM属性値:単位 */
    public static final String KEY_CCM_UNIT = "CcmUnit";
    /** 設定項目キー : CCM属性値：系統番号(複数系統アクチュエータ用) */
    public static final String KEY_CCM_LINE = "CcmLine";
    /** 設定項目キー : 複数系統の代表値フラグ */
    public static final String KEY_IS_REPRESENTATIVE = "IsRepresentative";

}
