/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs;

import java.net.InetAddress;

/**
 * CCM要求クラスです。
 * @author WaBit
 *
 */
public class UecsRequest {

    private long time;
    private InetAddress address;
    private int port;
    private byte[] data;

    /**
     * 要求データをセットしたインスタンスを返します。
     * @param address IPアドレス
     * @param port 通信ポート
     * @param data データ配列
     * @param time 送信時刻
     */
    public UecsRequest(InetAddress address, int port, byte[] data, long time) {
        this.address = address;
        this.port = port;
        this.data = data;
        this.time = time;
    }

    /**
     * 要求アドレスを取得します。
     * @return IPアドレス
     */
    public InetAddress getAddress() {
        return address;
    }

    /**
     * 要求ポートを設定します。
     * @return ポート番号
     */
    public int getPort() {
        return port;
    }

    /**
     * 要求データを取得します。
     * @return データ配列
     */
    public byte[] getData() {
        return data;
    }

    /**
     * 受信時刻を取得します。
     * @return 時刻(msec)
     */
    public long getTime() {
        return time;
    }
}
