/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs;

import java.io.IOException;

import com.wabit.uecs.util.PropertyConfig;


/**
 * 初期設定クラスです。
 *
 * @author WaBit
 *
 */
public class NodeConfig extends PropertyConfig {

    private static final long serialVersionUID = -1148528853140933527L;

    /** 設定項目キー : ベンダー名 */
    public static final String KEY_VENDER = "Vender";
    /** 設定項目キー : UECS ID */
    public static final String KEY_UECS_ID = "UecsId";
    /** 設定項目キー : UECSバージョン */
    public static final String KEY_UECS_VERSION = "UecsVersion";
    /** 設定項目キー : ノード名 */
    public static final String KEY_NODE_NAME = "NodeName";
    /** 設定項目キー : ノードIP */
    public static final String KEY_NODE_IP = "IpAddress";
    /** 設定項目キー : MACアドレス */
    public static final String KEY_NODE_MAC = "MacAddress";
    /** 設定項目キー : ブロードキャストIP */
    public static final String KEY_NODE_BROADCAST = "BroadcastAddress";
    /** 設定項目キー : ノード種別(kNN) */
    public static final String KEY_NODE_TYPE = "NodeType";
    /** 設定項目キー : room */
    public static final String KEY_NODE_ROOM = "Room";
    /** 設定項目キー : region */
    public static final String KEY_NODE_REGION = "Region";
    /** 設定項目キー : order */
    public static final String KEY_NODE_ORDER = "Order";
    /** 設定項目キー : priority */
    public static final String KEY_NODE_PRIORITY = "Priority";

    /**
     * 空のインスタンスを返します。
     */
    public NodeConfig() {

    }

    /**
     * コンストラクタ.
     *
     * @param xmlPath 読込元XMLファイルパス
     * @throws IOException 読込に失敗するとスローされます。
     */
    public NodeConfig(String xmlPath) throws IOException {
        super(xmlPath);
    }


}
