/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui;

import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.pi.db.DatabaseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IClusterable;

public class ComponentChoice
extends DropDownChoice<Row> {
    public static final String NEW_ID = "NewComponent";
    private Class<? extends IComponent<?>> componentCls;
    private boolean containsNew;

    public <U extends IComponent<?>> ComponentChoice(String id, Class<U> compoCls) {
        this(id, compoCls, true);
    }

    public <U extends IComponent<?>> ComponentChoice(String id, Class<U> compoCls, boolean containsNew) {
        super(id);
        this.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer("Name", "Id"));
        this.componentCls = compoCls;
        this.containsNew = containsNew;
    }

    public void init(String deviceId, String componentId) {
        List<Object> components = null;
        components = deviceId != null ? DatabaseUtils.loadComponents(deviceId) : Collections.emptyList();
        ArrayList<Row> rows = new ArrayList<Row>(components.size() + 1);
        if (this.containsNew) {
            Row row = new Row(NEW_ID, NEW_ID);
            rows.add(row);
        }
        for (IComponent iComponent : components) {
            if (!this.componentCls.isInstance(iComponent)) continue;
            Row row = new Row(iComponent.getId(), iComponent.getConfig().getString("ComponentName", ""));
            rows.add(row);
        }
        this.setChoices(rows);
        if (rows.size() > 0) {
            if (componentId == null || NEW_ID.equals(componentId)) {
                this.setModel((IModel)Model.of((Serializable)((Object)((Row)rows.get(0)))));
            } else {
                for (Row row : rows) {
                    if (!row.getId().equals(componentId)) continue;
                    this.setModel((IModel)Model.of((Serializable)((Object)row)));
                    break;
                }
            }
        }
    }

    protected boolean localizeDisplayValues() {
        return true;
    }

    public static final class Row
    implements IClusterable {
        private String id;
        private String name;

        public Row(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

