/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageUtils {
    public static final String CODE_FREE = "FREE";
    private static Locale locale = Locale.getDefault();
    private static List<String> pathList = new ArrayList<String>();
    private static List<ResourceBundle> resources = new ArrayList<ResourceBundle>();

    static {
        pathList.add("com.wabit.uecs.pi.util.MessageUtils");
        MessageUtils.refresh();
    }

    private MessageUtils() {
    }

    private static synchronized void refresh() {
        resources.clear();
        for (String path : pathList) {
            resources.add(ResourceBundle.getBundle(path, locale));
        }
    }

    public static void changeLocale(Locale newLocale) {
        locale = newLocale;
        MessageUtils.refresh();
    }

    public static void addResource(String resourcePath) {
        pathList.add(resourcePath);
        MessageUtils.refresh();
    }

    public static String getMessage(String code, Object ... args) {
        String message = null;
        for (ResourceBundle rb : resources) {
            if (!rb.containsKey(code)) continue;
            message = rb.getString(code);
            break;
        }
        return MessageFormat.format(message, args);
    }
}

