/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.pi.db.ComponentValueEntity;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.gpio.DigitalSensorBase;
import com.wabit.uecs.pi.device.gpio.PulseSensorConfig;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PulseSensor<T extends PulseSensorConfig>
extends DigitalSensorBase<T> {
    public static final String COUNT_METHOD_SUM = "SUM";
    public static final String COUNT_METHOD_DIFF = "DIFF";
    private long counter;
    private long countMax;
    private boolean countState;
    private boolean isDiffMethod;
    private ScheduledExecutorService diffCountExecutor;

    public PulseSensor(String id, T config) {
        super(id, config);
    }

    public long getCountNumber() {
        return this.counter;
    }

    public void resetCounter() {
        this.counter = 0L;
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        PulseSensorConfig config = (PulseSensorConfig)this.getConfig();
        this.countState = config.getBoolean("CountState", false);
        this.countMax = config.getLong("CountMax", Long.MAX_VALUE);
        if (COUNT_METHOD_DIFF.equals(config.getString("CountMethod", COUNT_METHOD_SUM))) {
            this.isDiffMethod = true;
        }
        if (!this.isDiffMethod) {
            long lastCountTime = config.getLong("LastCountTime", Long.MIN_VALUE);
            if (config.getInt("RecordInterval", 0) > 0) {
                long lastRecMilli = config.getLong("LastRecordedTime", Long.MIN_VALUE);
                if (lastRecMilli > lastCountTime) {
                    Date time = new Date(lastRecMilli);
                    List<ComponentValueEntity> values = DatabaseUtils.getComponentValues(this.getId(), time, null);
                    if (values.size() > 0) {
                        this.counter = values.get(0).getValue().longValue();
                    }
                } else {
                    this.counter = config.getLong("LastCountNum", 0L);
                }
            } else {
                this.counter = config.getLong("LastCountNum", 0L);
            }
        }
    }

    @Override
    protected void onStart() throws Exception {
        if (this.isDiffMethod) {
            long period = this.getCcmService().getCcm().getLevel().getCycleTime();
            this.diffCountExecutor = Executors.newSingleThreadScheduledExecutor();
            this.diffCountExecutor.scheduleAtFixedRate(new Runnable(){
                private long preCount;

                @Override
                public void run() {
                    if (this.preCount > PulseSensor.this.counter) {
                        PulseSensor.this.setValue(PulseSensor.this.countMax - this.preCount + PulseSensor.this.counter);
                    } else {
                        PulseSensor.this.setValue(PulseSensor.this.counter - this.preCount);
                    }
                    this.preCount = PulseSensor.this.counter;
                }
            }, 0L, period, TimeUnit.MILLISECONDS);
        } else {
            this.setValue(this.counter);
        }
        super.onStart();
    }

    @Override
    protected void onStop() throws Exception {
        if (this.diffCountExecutor != null) {
            this.diffCountExecutor.shutdown();
            this.diffCountExecutor = null;
        }
        if (!this.isDiffMethod) {
            DatabaseUtils.saveComponentConfig(this.getId(), "LastCountTime", Long.toString(System.currentTimeMillis()));
            DatabaseUtils.saveComponentConfig(this.getId(), "LastCountNum", Long.toString(this.counter));
        }
        super.onStop();
    }

    @Override
    protected void onSensePinStateChanged(boolean state) throws Exception {
        if (this.countState == state) {
            if (this.counter >= this.countMax) {
                this.counter = 0L;
            }
            ++this.counter;
            if (!this.isDiffMethod) {
                this.setValue(this.counter);
            }
        }
    }
}

