/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinEventType;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.pi.device.gpio.DigitalSwitchActuator;
import com.wabit.uecs.pi.device.gpio.GpioDeviceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DigitalSwitchInterlockAction
implements IActuatorAction,
GpioPinListenerDigital {
    private DigitalSwitchActuator<?> switchActuator;
    private Log logger = LogFactory.getLog(this.getClass());

    public synchronized void execute(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioPinDigitalInput inputPin = this.switchActuator.getGpioInputPin();
        if (inputPin.getState().isLow()) {
            this.switchActuator.on();
        } else {
            this.switchActuator.off();
        }
    }

    public void onStart(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        if (!(paramActuatorComponent instanceof DigitalSwitchActuator)) {
            throw new IllegalArgumentException("invalid actuator = " + paramActuatorComponent.getClass().getName());
        }
        this.switchActuator = (DigitalSwitchActuator)paramActuatorComponent;
        GpioDeviceBase device = (GpioDeviceBase)this.switchActuator.getDevice();
        device.addListener((GpioPinListener)this, (GpioPinInput)this.switchActuator.getGpioInputPin());
        this.execute(paramActuatorComponent);
    }

    public void onStop(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioDeviceBase device = (GpioDeviceBase)this.switchActuator.getDevice();
        device.removeListener((GpioPinListener)this, (GpioPinInput)this.switchActuator.getGpioInputPin());
    }

    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
        if (event.getEventType() == PinEventType.DIGITAL_STATE_CHANGE) {
            try {
                this.execute(this.switchActuator);
            }
            catch (Exception e) {
                this.logger.error((Object)"process faild.", (Throwable)e);
            }
        }
    }
}

