/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.device;

import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.device.AbstractDevice;
import com.wabit.uecs.device.DeviceException;
import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.IDeviceListener;
import com.wabit.uecs.pi.UecsPiLogger;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.PiDeviceConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PiDeviceBase<T extends PiDeviceConfig>
extends AbstractDevice<T> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private boolean enabled = true;

    protected PiDeviceBase(String deviceId, T config) {
        super(deviceId, config);
        this.addListener(new DeviceListener());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void init(IUecsNode<?> node) throws DeviceException {
        if (this.isEnabled()) {
            super.init(node);
        }
    }

    public void start() throws DeviceException {
        if (this.isEnabled()) {
            super.start();
        }
    }

    public void stop() throws DeviceException {
        if (this.isEnabled()) {
            super.stop();
        }
    }

    protected void onInit() throws Exception {
        for (IComponent<?> compo : DatabaseUtils.loadComponents(this.getId())) {
            this.addComponent(compo);
        }
    }

    protected void onStart() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ID=" + this.getId()));
        }
    }

    protected void onStop() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ID=" + this.getId()));
        }
    }

    private class DeviceListener
    implements IDeviceListener {
        private DeviceListener() {
        }

        public void deviceStarted(IDevice<?> device) {
            if (PiDeviceBase.this.logger.isDebugEnabled()) {
                PiDeviceBase.this.logger.debug((Object)("ID=" + device.getId()));
            }
        }

        public void deviceStopped(IDevice<?> device) {
            if (PiDeviceBase.this.logger.isDebugEnabled()) {
                PiDeviceBase.this.logger.debug((Object)("ID=" + device.getId()));
            }
        }

        public void handleDeviceException(IDevice<?> device, Exception e) {
            PiDeviceBase.this.logger.error((Object)("ID=" + device.getId()), (Throwable)e);
            UecsPiLogger.log("DEVICE", "message.deviceError", device.getConfig().getString("DeviceName"), e);
            PiDeviceBase.this.getNode().onStatus(0xC000000);
        }
    }
}

