/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol.handler;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.UecsRequest;
import com.wabit.uecs.UecsResponse;
import com.wabit.uecs.protocol.RequestCcm;
import com.wabit.uecs.protocol.SearchCcm;
import com.wabit.uecs.protocol.ServerCcm;
import com.wabit.uecs.protocol.XmlCcm;
import com.wabit.uecs.protocol.handler.AbstractProtocolHandler;
import java.util.List;

public class SearchProtocolHandler
extends AbstractProtocolHandler {
    public SearchProtocolHandler(IUecsNode<?> node) {
        super(node);
    }

    @Override
    public int getPort() {
        return 16521;
    }

    @Override
    protected void handleCcm(UecsRequest req, UecsResponse res, XmlCcm ccm) throws Exception {
        if (ccm instanceof SearchCcm) {
            this.handleSearchCcm(req, res, (SearchCcm)ccm);
        } else if (ccm instanceof ServerCcm) {
            this.handleServerCcm(req, res, (ServerCcm)ccm);
        } else {
            throw new Exception("illegal packet : " + ccm.toString());
        }
    }

    private void handleSearchCcm(UecsRequest req, UecsResponse res, SearchCcm sccm) {
        IUecsNode<?> node = this.getNode();
        List<CcmService> list = node.listCcmService();
        for (CcmService sv : list) {
            Ccm dccm = sv.getCcm();
            if (dccm.getSide() != 'S' || dccm.getLevel().getCategory() != 'B' || !dccm.getType().equals(sccm.getType()) || sccm.getRoom() != 0 && dccm.getRoom() != sccm.getRoom() || sccm.getRegion() != 0 && dccm.getRegion() != sccm.getRegion() || sccm.getOrder() != 0 && dccm.getOrder() != sccm.getOrder()) continue;
            ServerCcm svccm = new ServerCcm();
            svccm.setUecsVersion(dccm.getUecsVersion());
            svccm.setType(dccm.getType());
            svccm.setRoom(dccm.getRoom());
            svccm.setRegion(dccm.getRegion());
            svccm.setOrder(dccm.getOrder());
            svccm.setPriority(dccm.getPriority());
            svccm.setIpAddress(node.getIpAddress());
            res.setAddress(node.getBroadcastAddress());
            res.setPort(svccm.getPort());
            res.setData(svccm.toXmlBytes());
        }
    }

    private void handleServerCcm(UecsRequest req, UecsResponse res, ServerCcm sccm) {
        IUecsNode<?> node = this.getNode();
        List<CcmService> list = node.listCcmService();
        for (CcmService sv : list) {
            Ccm dccm = sv.getCcm();
            if (dccm.getSide() != 'R' || dccm.getLevel().getCategory() != 'B' || !dccm.getType().equals(sccm.getType()) || sccm.getRoom() != 0 && dccm.getRoom() != sccm.getRoom() || sccm.getRegion() != 0 && dccm.getRegion() != sccm.getRegion() || sccm.getOrder() != 0 && dccm.getOrder() != sccm.getOrder()) continue;
            RequestCcm request = new RequestCcm();
            request.setUecsVersion(dccm.getUecsVersion());
            request.setType(dccm.getType());
            request.setRoom(dccm.getRoom());
            request.setRegion(dccm.getRegion());
            request.setOrder(dccm.getOrder());
            request.setPriority(dccm.getPriority());
            res.setAddress(req.getAddress());
            res.setPort(request.getPort());
            res.setData(request.toXmlBytes());
        }
    }
}

