/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmID;
import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.protocol.XmlCcm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class CcmScanReplyCcm
extends XmlCcm {
    public static final String TAG_CCMNUM = "CCMNUM";
    public static final String TAG_CCM = "CCM";
    public static final String ATTR_PAGE = "page";
    public static final String ATTR_TOTAL = "total";
    public static final String ATTR_NO = "No";
    public static final String ATTR_CAST = "cast";
    public static final String ATTR_UNIT = "unit";
    public static final String ATTR_SR = "SR";
    public static final String ATTR_LV = "LV";
    private SortedMap<Integer, Ccm> ccmMap = Collections.synchronizedSortedMap(new TreeMap());
    private int page = 1;
    private int total = 1;
    private Ccm lastCcm;

    public int getPage() {
        return this.page;
    }

    public int getTotal() {
        return this.total;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void putCcm(int no, Ccm ccm) {
        this.ccmMap.put(no, ccm);
    }

    public Ccm removeCcm(int no) {
        return (Ccm)this.ccmMap.remove(no);
    }

    public Ccm getCcm(int no) {
        return (Ccm)this.ccmMap.get(new Integer(no));
    }

    public List<Integer> listCcmNo() {
        return new ArrayList<Integer>(this.ccmMap.keySet());
    }

    @Override
    void appendXml(StringBuilder sb) {
        sb.append("<").append(TAG_CCMNUM);
        sb.append(" page=\"").append(this.page);
        sb.append("\" total=\"").append(this.total).append("\">");
        sb.append(this.ccmMap.size());
        sb.append("</").append(TAG_CCMNUM).append(">");
        for (Integer no : this.ccmMap.keySet()) {
            Ccm data = (Ccm)this.ccmMap.get(no);
            sb.append("<").append(TAG_CCM);
            sb.append(" No=\"").append(no).append("\"");
            sb.append(" room=\"").append(data.getRoom()).append("\"");
            sb.append(" region=\"").append(data.getRegion()).append("\"");
            sb.append(" order=\"").append(data.getOrder()).append("\"");
            sb.append(" priority=\"").append(data.getPriority()).append("\"");
            sb.append(" cast=\"").append(data.getCast()).append("\"");
            sb.append(" unit=\"").append(CcmScanReplyCcm.escape(data.getUnit())).append("\"");
            sb.append(" SR=\"").append(CcmScanReplyCcm.escape(Character.valueOf(data.getSide()))).append("\"");
            sb.append(" LV=\"").append(CcmScanReplyCcm.escape(data.getLevel())).append("\"");
            sb.append(">");
            sb.append(CcmScanReplyCcm.escape(data.getType()));
            sb.append("</").append(TAG_CCM).append(">");
        }
    }

    @Override
    void importXml(Document doc) throws Exception {
        Element elm = (Element)doc.getElementsByTagName(TAG_CCMNUM).item(0);
        String val = elm.getAttribute(ATTR_PAGE);
        this.setPage(Integer.parseInt(val));
        val = elm.getAttribute(ATTR_TOTAL);
        this.setTotal(Integer.parseInt(val));
        NodeList list = doc.getElementsByTagName(TAG_CCM);
        int i = 0;
        while (i < list.getLength()) {
            elm = (Element)list.item(i);
            int no = Integer.parseInt(elm.getAttribute(ATTR_NO));
            Ccm ccmData = new Ccm();
            ccmData.setCast(Integer.parseInt(elm.getAttribute(ATTR_CAST)));
            ccmData.setUnit(elm.getAttribute(ATTR_UNIT));
            val = elm.getAttribute("room");
            ccmData.setRoom(Integer.parseInt(val));
            val = elm.getAttribute("region");
            ccmData.setRegion(Integer.parseInt(val));
            val = elm.getAttribute("order");
            ccmData.setOrder(Integer.parseInt(val));
            val = elm.getAttribute("priority");
            ccmData.setPriority(Integer.parseInt(val));
            val = elm.getAttribute(ATTR_SR);
            ccmData.setSide(val.charAt(0));
            val = elm.getAttribute(ATTR_LV);
            ccmData.setLevel(new CcmLevel(val));
            val = elm.getFirstChild().getNodeValue();
            ccmData.setType(new CcmID(val));
            this.putCcm(no, ccmData);
            ++i;
        }
    }

    @Override
    public int getPort() {
        return 16529;
    }

    @Override
    void setXmlAttributes(String tagName, Attributes attributes) {
        if (TAG_CCMNUM.equals(tagName)) {
            String val = attributes.getValue(ATTR_PAGE);
            this.setPage(Integer.parseInt(val));
            val = attributes.getValue(ATTR_TOTAL);
            this.setTotal(Integer.parseInt(val));
        } else if (TAG_CCM.equals(tagName)) {
            int no = Integer.parseInt(attributes.getValue(ATTR_NO));
            Ccm ccmData = new Ccm();
            ccmData.setCast(Integer.parseInt(attributes.getValue(ATTR_CAST)));
            ccmData.setUnit(attributes.getValue(ATTR_UNIT));
            String val = attributes.getValue("room");
            ccmData.setRoom(Integer.parseInt(val));
            val = attributes.getValue("region");
            ccmData.setRegion(Integer.parseInt(val));
            val = attributes.getValue("order");
            ccmData.setOrder(Integer.parseInt(val));
            val = attributes.getValue("priority");
            ccmData.setPriority(Integer.parseInt(val));
            val = attributes.getValue(ATTR_SR);
            ccmData.setSide(val.charAt(0));
            val = attributes.getValue(ATTR_LV);
            ccmData.setLevel(new CcmLevel(val));
            this.lastCcm = ccmData;
            this.putCcm(no, ccmData);
        }
    }

    @Override
    void setXmlValue(String tagName, String value) {
        if (TAG_CCM.equals(tagName)) {
            this.lastCcm.setType(new CcmID(value));
        }
    }
}

