/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device.sensor;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmID;
import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.ICcmServiceListener;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.device.AbstractComponent;
import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.util.PropertyConfig;

public abstract class SensorComponent<T extends ComponentConfig>
extends AbstractComponent<T> {
    private CcmService ccmService;

    public SensorComponent(String id, T config) {
        super(id, config);
    }

    @Override
    public void setValue(Number value) {
        this.getCcmService().updateValue(value);
        super.setValue(value);
    }

    public CcmService getCcmService() {
        return this.ccmService;
    }

    @Override
    public void init(IDevice<?> device) throws Exception {
        this.setDevice(device);
        IUecsNode<?> node = this.getDevice().getNode();
        Object config = this.getConfig();
        String name = ((PropertyConfig)config).getString("ComponentName");
        String ccmInfoName = ((PropertyConfig)config).getString("CcmInfoName", "");
        String ccmNodeType = ((PropertyConfig)config).getString("CcmNodeType", "");
        String ccmLevel = ((PropertyConfig)config).getString("CcmLevel");
        String unit = ((PropertyConfig)config).getString("CcmUnit");
        char side = ((PropertyConfig)config).getString("CcmSide", "R").charAt(0);
        int ccmRoom = ((PropertyConfig)config).getInt("CcmRoom", 0);
        int ccmRegion = ((PropertyConfig)config).getInt("CcmRegion", 0);
        int ccmOrder = ((PropertyConfig)config).getInt("CcmOrder", 0);
        int ccmPriority = ((PropertyConfig)config).getInt("CcmPriority", 0);
        int ccmCast = ((PropertyConfig)config).getInt("CcmCast", 0);
        String ccmId = ccmInfoName;
        if (ccmNodeType != null && ccmNodeType.length() > 0) {
            ccmId = String.valueOf(ccmId) + "." + ccmNodeType;
        }
        Ccm ccm = new Ccm();
        ccm.setSide(side);
        ccm.setType(new CcmID(ccmId));
        ccm.setUnit(unit);
        ccm.setCast(ccmCast);
        ccm.setRoom(ccmRoom);
        ccm.setRegion(ccmRegion);
        ccm.setOrder(ccmOrder);
        ccm.setPriority(ccmPriority);
        ccm.setLevel(new CcmLevel(ccmLevel));
        this.ccmService = new CcmService(ccm);
        this.ccmService.setName(name);
        if (side == 'R') {
            this.ccmService.addListener(new InnerListener());
        }
        node.addCcmService(this.ccmService);
        this.onInit();
    }

    @Override
    public void start() throws Exception {
        this.getCcmService().updateValue(this.getValue());
        this.onStart();
        this.notifyStarted();
    }

    private class InnerListener
    implements ICcmServiceListener {
        private InnerListener() {
        }

        @Override
        public void ccmValueChanged(CcmService source, Ccm value) {
            SensorComponent.super.setValue(value.getNumberValue());
        }

        @Override
        public void ccmExpired(CcmService source, Ccm value) {
            SensorComponent.super.setValue(null);
        }

        @Override
        public void ccmSent(CcmService source, Ccm value) {
        }

        @Override
        public void ccmReceived(CcmService source, Ccm value) {
        }
    }
}

