/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device.actuator;

import com.wabit.uecs.device.actuator.AbstractCyclicAction;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.IActuatorAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DailySchedulerAction
extends AbstractCyclicAction {
    private List<Schedule> schedules = new ArrayList<Schedule>();
    private IActuatorAction resetAction;

    public DailySchedulerAction() {
        super(10000L);
    }

    public DailySchedulerAction(long checkInterval) {
        super(checkInterval);
    }

    public void setResetAction(IActuatorAction action) {
        this.resetAction = action;
    }

    @Override
    public void onStart(ActuatorComponent<?> component) throws Exception {
        for (Schedule sc : this.schedules) {
            sc.action.onStart(component);
        }
        if (this.resetAction != null) {
            this.resetAction.onStart(component);
        }
        super.onStart(component);
    }

    @Override
    public void onStop(ActuatorComponent<?> component) throws Exception {
        super.onStop(component);
        for (Schedule sc : this.schedules) {
            sc.action.onStop(component);
        }
        if (this.resetAction != null) {
            this.resetAction.onStop(component);
        }
    }

    @Override
    public void execute(ActuatorComponent<?> component) throws Exception {
        for (Schedule sc : this.schedules) {
            Calendar cal = Calendar.getInstance();
            int hm = cal.get(11) * 10000 + cal.get(12) * 100 + cal.get(13);
            if (sc.startHM < sc.endHM) {
                if (hm >= sc.startHM && hm <= sc.endHM) {
                    sc.action.execute(component);
                    continue;
                }
                if (this.resetAction == null) continue;
                this.resetAction.execute(component);
                continue;
            }
            if (sc.startHM <= sc.endHM) continue;
            if (hm >= sc.startHM && hm <= 235959 || hm >= 0 && hm <= sc.endHM) {
                sc.action.execute(component);
                continue;
            }
            if (this.resetAction == null) continue;
            this.resetAction.execute(component);
        }
    }

    public void addSchedule(IActuatorAction action, int startHour, int startMin, int endHour, int endMin) {
        Schedule sc = new Schedule();
        sc.action = action;
        sc.startHM = startHour * 10000 + startMin * 100;
        sc.endHM = endHour * 10000 + endMin * 100;
        this.schedules.add(sc);
    }

    private class Schedule {
        int startHM;
        int endHM;
        IActuatorAction action;

        private Schedule() {
        }
    }
}

