/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs;

import com.wabit.uecs.NodeRuntimeException;

public final class CcmID {
    private MajorDivision category;
    private String nodeType;
    private String infoName;
    private String code;

    protected CcmID() {
    }

    public CcmID(String code) {
        if (code == null || code.length() < 3 || code.length() > 19) {
            throw new NodeRuntimeException("ID length violation. code=" + code);
        }
        this.code = code;
        if (code.length() > 4 && code.charAt(code.length() - 4) == '.') {
            int sep = code.length() - 4;
            this.infoName = code.substring(0, sep);
            this.category = MajorDivision.toEnum(code.charAt(sep + 1));
            this.nodeType = code.substring(sep + 2);
        } else {
            this.infoName = code;
            this.category = null;
            this.nodeType = null;
        }
    }

    public CcmID(String infoName, String nodeType) {
        if (infoName == null || infoName.length() == 0) {
            throw new NodeRuntimeException("illegal InfoName=" + infoName);
        }
        this.infoName = infoName;
        if (nodeType != null && nodeType.length() > 0) {
            if (nodeType.length() != 3) {
                throw new NodeRuntimeException("illegal NodeType=" + nodeType);
            }
            this.category = MajorDivision.toEnum(nodeType.charAt(0));
            this.nodeType = nodeType;
            this.code = String.valueOf(this.infoName) + "." + nodeType;
        } else {
            this.code = nodeType.length() > 0 ? String.valueOf(this.infoName) + "." + nodeType : this.infoName;
        }
    }

    public String getInfoName() {
        return this.infoName;
    }

    public MajorDivision getMajorDivision() {
        return this.category;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof CcmID) {
            return this.code.equals(((CcmID)o).code);
        }
        return false;
    }

    public static enum MajorDivision {
        Actuator("a"),
        Controller("c"),
        Measure("m"),
        Unknown("x");

        private String codeStr;

        private MajorDivision(String code) {
            this.codeStr = code;
        }

        public char getCode() {
            return this.codeStr.charAt(0);
        }

        public String toString() {
            return this.codeStr;
        }

        public static MajorDivision toEnum(char code) {
            switch (code) {
                case 'a': {
                    return Actuator;
                }
                case 'c': {
                    return Controller;
                }
                case 'm': {
                    return Measure;
                }
            }
            return Unknown;
        }
    }
}

