/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol;

import com.wabit.uecs.protocol.CcmParserException;
import com.wabit.uecs.protocol.CcmScanCcm;
import com.wabit.uecs.protocol.CcmScanReplyCcm;
import com.wabit.uecs.protocol.DataCcm;
import com.wabit.uecs.protocol.NodeScanCcm;
import com.wabit.uecs.protocol.NodeScanReplyCcm;
import com.wabit.uecs.protocol.RequestCcm;
import com.wabit.uecs.protocol.SearchCcm;
import com.wabit.uecs.protocol.ServerCcm;
import com.wabit.uecs.protocol.XmlCcm;
import java.io.CharArrayWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlCcmParser
extends DefaultHandler {
    private static SAXParserFactory spfactory = SAXParserFactory.newInstance();
    private boolean isUecs;
    private String version;
    private XmlCcm xmlCcm;
    private CharArrayWriter buffer;

    public synchronized XmlCcm parseBytes(byte[] xmlBytes) throws CcmParserException {
        if (xmlBytes == null || xmlBytes.length == 0) {
            return null;
        }
        String ccm = null;
        try {
            ccm = new String(xmlBytes, "iso-8859-1");
            return this.parseXml(ccm);
        }
        catch (UnsupportedEncodingException e) {
            throw new CcmParserException(e.getMessage(), e, ccm);
        }
    }

    public synchronized XmlCcm parseXml(String xml) throws CcmParserException {
        SAXParser saxParser;
        if (xml == null || xml.length() == 0) {
            return null;
        }
        try {
            saxParser = spfactory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InputSource source = new InputSource(new StringReader(xml));
        try {
            saxParser.parse(source, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new CcmParserException("CCM parse error.", e, xml);
        }
        if (this.xmlCcm == null) {
            throw new CcmParserException("unknown CCM.", null, xml);
        }
        return this.xmlCcm;
    }

    @Override
    public void startDocument() {
        this.xmlCcm = null;
        this.version = null;
        this.buffer = new CharArrayWriter();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.xmlCcm == null && "UECS".equals(qName)) {
            this.isUecs = true;
            this.version = attributes.getValue("ver");
            return;
        }
        if (!this.isUecs) {
            return;
        }
        if (this.xmlCcm == null) {
            this.xmlCcm = XmlCcmParser.createCcmCcm(qName);
            this.xmlCcm.setUecsVersion(this.version);
        }
        try {
            this.xmlCcm.setXmlAttributes(qName, attributes);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.xmlCcm != null && this.buffer.size() > 0) {
            try {
                this.xmlCcm.setXmlValue(qName, this.buffer.toString().trim());
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            this.buffer.reset();
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        this.buffer.write(ch, offset, length);
    }

    private static XmlCcm createCcmCcm(String tagName) throws SAXException {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        XmlCcm ccm = null;
        if ("DATA".equals(tagName)) {
            ccm = new DataCcm();
        } else if ("REQUEST".equals(tagName)) {
            ccm = new RequestCcm();
        } else if ("SEARCH".equals(tagName)) {
            ccm = new SearchCcm();
        } else if ("SERVER".equals(tagName)) {
            ccm = new ServerCcm();
        } else if ("NODESCAN".equals(tagName)) {
            ccm = new NodeScanCcm();
        } else if ("NODE".equals(tagName)) {
            ccm = new NodeScanReplyCcm();
        } else if ("CCMSCAN".equals(tagName)) {
            ccm = new CcmScanCcm();
        } else if ("CCMNUM".equals(tagName)) {
            ccm = new CcmScanReplyCcm();
        } else {
            throw new SAXException("can't find CCM type tag.");
        }
        return ccm;
    }
}

