/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.protocol;

import com.wabit.uecs.protocol.XmlCcm;
import com.wabit.uecs.util.CommonUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NodeScanReplyCcm
extends XmlCcm {
    public static final String TAG_NODE = "NODE";
    public static final String TAG_NAME = "NAME";
    public static final String TAG_VENDER = "VENDER";
    public static final String TAG_UECSID = "UECSID";
    public static final String TAG_IP = "IP";
    public static final String TAG_MAC = "MAC";
    private String name;
    private String vender;
    private String uecsID;
    private InetAddress ipAddress;
    private byte[] macAddress;

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(InetAddress address) {
        this.ipAddress = address;
    }

    public String getName() {
        return this.name;
    }

    public String getVender() {
        return this.vender;
    }

    public String getUecsID() {
        return this.uecsID;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVender(String vender) {
        this.vender = vender;
    }

    public void setUecsID(String uecsID) {
        this.uecsID = uecsID;
    }

    public void setMacAddress(byte[] macAddress) {
        this.macAddress = macAddress;
    }

    @Override
    void appendXml(StringBuilder sb) {
        sb.append("<").append(TAG_NODE).append(">");
        sb.append("<").append(TAG_NAME);
        if (this.name != null && this.name.length() != 0) {
            sb.append(">");
            sb.append(NodeScanReplyCcm.escape(this.name));
            sb.append("</").append(TAG_NAME).append(">");
        } else {
            sb.append("/>");
        }
        sb.append("<").append(TAG_VENDER);
        if (this.vender != null && this.vender.length() != 0) {
            sb.append(">");
            sb.append(NodeScanReplyCcm.escape(this.vender));
            sb.append("</").append(TAG_VENDER).append(">");
        } else {
            sb.append("/>");
        }
        sb.append("<").append(TAG_UECSID);
        if (this.uecsID != null && this.uecsID.length() != 0) {
            sb.append(">");
            sb.append(NodeScanReplyCcm.escape(this.uecsID));
            sb.append("</").append(TAG_UECSID).append(">");
        } else {
            sb.append("/>");
        }
        sb.append("<").append(TAG_IP);
        if (this.ipAddress != null) {
            sb.append(">");
            sb.append(this.ipAddress.getHostAddress());
            sb.append("</").append(TAG_IP).append(">");
        } else {
            sb.append("/>");
        }
        sb.append("<").append(TAG_MAC);
        if (this.macAddress != null) {
            sb.append(">");
            sb.append(CommonUtils.bytesToHex(this.macAddress));
            sb.append("</").append(TAG_MAC).append(">");
        } else {
            sb.append("/>");
        }
        sb.append("</").append(TAG_NODE).append(">");
    }

    @Override
    void importXml(Document doc) throws Exception {
        Element elm = (Element)doc.getElementsByTagName(TAG_NAME).item(0);
        String val = elm.getFirstChild().getNodeValue();
        if (val != null && val.length() != 0) {
            this.setName(val);
        }
        if ((val = (elm = (Element)doc.getElementsByTagName(TAG_VENDER).item(0)).getFirstChild().getNodeValue()) != null && val.length() != 0) {
            this.setVender(val);
        }
        if ((val = (elm = (Element)doc.getElementsByTagName(TAG_UECSID).item(0)).getFirstChild().getNodeValue()) != null && val.length() != 0) {
            this.setUecsID(val);
        }
        if ((val = (elm = (Element)doc.getElementsByTagName(TAG_IP).item(0)).getFirstChild().getNodeValue()) != null && val.length() != 0) {
            this.ipAddress = InetAddress.getByName(val);
        }
        if ((val = (elm = (Element)doc.getElementsByTagName(TAG_MAC).item(0)).getFirstChild().getNodeValue()) != null && val.length() != 0) {
            this.setMacAddress(CommonUtils.hexToBytes(val));
        }
    }

    @Override
    public int getPort() {
        return 16529;
    }

    @Override
    void setXmlAttributes(String tagName, Attributes attributes) {
    }

    @Override
    void setXmlValue(String tagName, String val) throws SAXException {
        if (TAG_NAME.equals(tagName) && val != null && val.length() != 0) {
            this.setName(val);
        }
        if (TAG_VENDER.equals(tagName) && val != null && val.length() != 0) {
            this.setVender(val);
        }
        if (TAG_UECSID.equals(tagName) && val != null && val.length() != 0) {
            this.setUecsID(val);
        }
        if (TAG_IP.equals(tagName) && val != null && val.length() != 0) {
            try {
                this.ipAddress = InetAddress.getByName(val);
            }
            catch (UnknownHostException e) {
                throw new SAXException(e);
            }
        }
        if (TAG_MAC.equals(tagName) && val != null && val.length() != 0) {
            this.setMacAddress(CommonUtils.hexToBytes(val));
        }
    }
}

