/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device.actuator;

import com.wabit.uecs.device.actuator.AbstractCyclicAction;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import java.util.Calendar;

public class PeriodicSwitchAction
extends AbstractCyclicAction {
    private long periodicInterval;
    private long onInterval;
    private long lastOnTime;
    private int inactiveStart = -1;
    private int inactiveEnd = -1;

    public PeriodicSwitchAction() {
        super(1000L);
    }

    public long getPeriodicInterval() {
        return this.periodicInterval;
    }

    public void setPeriodicInterval(long periodicInterval) {
        this.periodicInterval = periodicInterval;
    }

    public long getOnInterval() {
        return this.onInterval;
    }

    public void setOnInterval(long interval) {
        this.onInterval = interval;
    }

    public void setInactiveStartTime(int hour, int min) {
        this.inactiveStart = hour * 10000 + min * 100;
    }

    public void setInactiveEndTime(int hour, int min) {
        this.inactiveEnd = hour * 10000 + min * 100;
    }

    @Override
    public void execute(ActuatorComponent<?> component) throws Exception {
        long current;
        long delay;
        if (this.inactiveStart >= 0 && this.inactiveEnd >= 0) {
            Calendar cal = Calendar.getInstance();
            int time = cal.get(11) * 10000 + cal.get(12) * 100 + cal.get(13);
            if (this.inactiveStart < this.inactiveEnd ? time >= this.inactiveStart && time <= this.inactiveEnd : this.inactiveStart > this.inactiveEnd && (time >= this.inactiveStart && time <= 235959 || time >= 0 && time <= this.inactiveEnd)) {
                return;
            }
        }
        if ((delay = (current = System.currentTimeMillis()) - this.lastOnTime) >= this.periodicInterval) {
            if (this.lastOnTime == 0L || component.getValue() == null || component.getValue().intValue() != 1) {
                component.setValue(1);
            }
            this.lastOnTime = current;
        } else if (delay > this.onInterval && (component.getValue() == null || component.getValue().intValue() != 0)) {
            component.setValue(0);
        }
    }
}

