/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.device.actuator;

import com.wabit.uecs.ActionMode;
import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmService;
import com.wabit.uecs.ICcmServiceListener;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.ccm.OprCcm;
import com.wabit.uecs.ccm.RcACcm;
import com.wabit.uecs.ccm.RcMCcm;
import com.wabit.uecs.device.AbstractComponent;
import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.actuator.IActuatorAction;
import com.wabit.uecs.device.actuator.ICcmListenerAction;
import com.wabit.uecs.util.PropertyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ActuatorComponent<T extends ComponentConfig>
extends AbstractComponent<T> {
    private ActionMode actionMode = ActionMode.Autonomy;
    private Map<ActionMode, IActuatorAction> modeActions = new HashMap<ActionMode, IActuatorAction>();
    private List<CcmService> oprServices = new ArrayList<CcmService>();
    private List<CcmService> rcAServices = new ArrayList<CcmService>();
    private List<CcmService> rcMServices = new ArrayList<CcmService>();
    boolean isRepresentative;
    private ICcmServiceListener ccmListener = new InnerCcmListener();

    public ActuatorComponent(String id, T config) {
        super(id, config);
    }

    public CcmService[] getOprServices() {
        return this.oprServices.toArray(new CcmService[this.oprServices.size()]);
    }

    public CcmService[] getRcAServices() {
        return this.rcAServices.toArray(new CcmService[this.rcAServices.size()]);
    }

    public CcmService[] getRcMServices() {
        return this.rcMServices.toArray(new CcmService[this.rcMServices.size()]);
    }

    @Override
    public void setValue(Number value) {
        super.setValue(value);
        for (CcmService oprService : this.oprServices) {
            oprService.updateValue(value);
        }
    }

    public CcmService getActiveRcAService() {
        for (CcmService rcASv : this.rcAServices) {
            if (rcASv.isExpired()) continue;
            return rcASv;
        }
        return null;
    }

    public CcmService getActiveRcMService() {
        for (CcmService rcMSv : this.rcMServices) {
            if (rcMSv.isExpired()) continue;
            return rcMSv;
        }
        return null;
    }

    public ActionMode getActionMode() {
        return this.actionMode;
    }

    protected void setActionMode(ActionMode mode) {
        this.actionMode = mode;
        if (this.getDevice() != null && this.getDevice().getNode() != null) {
            IUecsNode<?> node = this.getDevice().getNode();
            if (this.isRepresentative()) {
                node.setActionMode(this.actionMode);
            }
        }
    }

    public synchronized void changeMode(ActionMode mode) throws Exception {
        IActuatorAction action = null;
        if (this.getActionMode() != mode) {
            action = this.modeActions.get((Object)this.getActionMode());
            if (action != null) {
                action.onStop(this);
            }
            if ((action = this.modeActions.get((Object)mode)) != null) {
                action.onStart(this);
            }
        }
        this.setActionMode(mode);
    }

    public void setAction(ActionMode mode, IActuatorAction action) {
        this.modeActions.put(mode, action);
        if (action instanceof ICcmListenerAction) {
            ICcmListenerAction ccmAction = (ICcmListenerAction)action;
            CcmService[] ccmServiceArray = ccmAction.getCcmServices();
            int n = ccmServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                CcmService ccmSv = ccmServiceArray[n2];
                if (ccmSv != null) {
                    ccmSv.addListener(this.ccmListener);
                }
                ++n2;
            }
        }
    }

    public IActuatorAction getAction(ActionMode mode) {
        return this.modeActions.get((Object)mode);
    }

    public boolean isRepresentative() {
        return this.isRepresentative;
    }

    @Override
    public void notifyException(Exception e) {
        super.notifyException(e);
    }

    @Override
    public void init(IDevice<?> device) throws Exception {
        RcMCcm rcM;
        RcACcm rcA;
        OprCcm opr;
        this.setDevice(device);
        IUecsNode<?> node = this.getDevice().getNode();
        Object nodeConfig = node.getConfig();
        String nodeType = ((PropertyConfig)nodeConfig).getString("NodeType");
        int nodeRoom = ((PropertyConfig)nodeConfig).getInt("Room", 0);
        int nodeRegion = ((PropertyConfig)nodeConfig).getInt("Region", 0);
        int nodeOrder = ((PropertyConfig)nodeConfig).getInt("Order", 0);
        int nodePriority = ((PropertyConfig)nodeConfig).getInt("Priority", 0);
        Object config = this.getConfig();
        String name = ((PropertyConfig)config).getString("ComponentName");
        String ccmInfoName = ((PropertyConfig)config).getString("CcmInfoName");
        String ccmNodeType = ((PropertyConfig)config).getString("CcmNodeType");
        String unit = ((PropertyConfig)config).getString("CcmUnit");
        int ccmRoom = ((PropertyConfig)config).getInt("CcmRoom", 0);
        int ccmRegion = ((PropertyConfig)config).getInt("CcmRegion", 0);
        int ccmOrder = ((PropertyConfig)config).getInt("CcmOrder", 0);
        int ccmPriority = ((PropertyConfig)config).getInt("CcmPriority", 0);
        int ccmLine = ((PropertyConfig)config).getInt("CcmLine", 0);
        boolean bl = this.isRepresentative = ((PropertyConfig)config).getString("CcmInfoName", "").length() == 0 && ((PropertyConfig)config).getInt("CcmLine", 0) == 0 && nodeType.equals(((PropertyConfig)config).getString("CcmNodeType")) && nodeRoom == ccmRoom && nodeRegion == ccmRegion && nodeOrder == ccmOrder && nodePriority == ccmPriority;
        if (!this.isRepresentative && ((PropertyConfig)config).getBoolean("IsRepresentative", false)) {
            this.isRepresentative = true;
            opr = new OprCcm(nodeType);
            opr.setSide('S');
            opr.setUnit(unit);
            opr.setRoom(nodeRoom);
            opr.setRegion(nodeRegion);
            opr.setOrder(nodeOrder);
            opr.setPriority(nodePriority);
            CcmService oprServiceR = new CcmService(opr);
            oprServiceR.setName(name);
            node.addCcmService(oprServiceR);
            this.oprServices.add(oprServiceR);
            rcA = new RcACcm(nodeType);
            rcA.setSide('R');
            rcA.setUnit(unit);
            rcA.setRoom(nodeRoom);
            rcA.setRegion(nodeRegion);
            rcA.setOrder(nodeOrder);
            rcA.setPriority(nodePriority);
            CcmService rcAServiceR = new CcmService(rcA);
            rcAServiceR.setName(name);
            rcAServiceR.addListener(this.ccmListener);
            node.addCcmService(rcAServiceR);
            this.rcAServices.add(rcAServiceR);
            rcM = new RcMCcm(nodeType);
            rcM.setSide('R');
            rcM.setUnit(unit);
            rcM.setRoom(nodeRoom);
            rcM.setRegion(nodeRegion);
            rcM.setOrder(nodeOrder);
            rcM.setPriority(nodePriority);
            CcmService rcMServiceR = new CcmService(rcM);
            rcMServiceR.setName(name);
            rcMServiceR.addListener(this.ccmListener);
            node.addCcmService(rcMServiceR);
            this.rcMServices.add(rcMServiceR);
        }
        opr = new OprCcm(ccmNodeType, ccmInfoName, ccmLine);
        opr.setSide('S');
        opr.setUnit(unit);
        opr.setRoom(ccmRoom);
        opr.setRegion(ccmRegion);
        opr.setOrder(ccmOrder);
        opr.setPriority(ccmPriority);
        CcmService oprService = new CcmService(opr);
        oprService.setName(name);
        node.addCcmService(oprService);
        this.oprServices.add(oprService);
        rcA = new RcACcm(ccmNodeType, ccmInfoName, ccmLine);
        rcA.setSide('R');
        rcA.setUnit(unit);
        rcA.setRoom(ccmRoom);
        rcA.setRegion(ccmRegion);
        rcA.setOrder(ccmOrder);
        rcA.setPriority(ccmPriority);
        CcmService rcAService = new CcmService(rcA);
        rcAService.setName(name);
        rcAService.addListener(this.ccmListener);
        node.addCcmService(rcAService);
        this.rcAServices.add(rcAService);
        rcM = new RcMCcm(ccmNodeType, ccmInfoName, ccmLine);
        rcM.setSide('R');
        rcM.setUnit(unit);
        rcM.setRoom(ccmRoom);
        rcM.setRegion(ccmRegion);
        rcM.setOrder(ccmOrder);
        rcM.setPriority(ccmPriority);
        CcmService rcMService = new CcmService(rcM);
        rcMService.setName(name);
        rcMService.addListener(this.ccmListener);
        node.addCcmService(rcMService);
        this.rcMServices.add(rcMService);
        super.init(device);
    }

    @Override
    public void start() throws Exception {
        this.onStart();
        IActuatorAction action = this.modeActions.get((Object)this.actionMode);
        if (action != null) {
            action.onStart(this);
        }
        this.notifyStarted();
    }

    @Override
    public void stop() throws Exception {
        IActuatorAction action = this.modeActions.get((Object)this.actionMode);
        if (action != null) {
            action.onStop(this);
        }
        this.onStop();
        this.notifyStopped();
    }

    private boolean acceptCcmAction(ActionMode mode, Ccm ccm) throws Exception {
        IActuatorAction action = this.modeActions.get((Object)mode);
        return action != null && action instanceof ICcmListenerAction && ((ICcmListenerAction)action).isAccepted(ccm);
    }

    private boolean isInactive(ActionMode mode) throws Exception {
        IActuatorAction action = this.modeActions.get((Object)mode);
        return action == null || action instanceof ICcmListenerAction && ((ICcmListenerAction)action).isExpired();
    }

    private class InnerCcmListener
    implements ICcmServiceListener {
        private InnerCcmListener() {
        }

        @Override
        public synchronized void ccmValueChanged(CcmService service, Ccm ccm) {
            if (ActionMode.Outage == ActuatorComponent.this.getActionMode()) {
                return;
            }
            try {
                ActionMode exeMode = null;
                Number num = ccm.getNumberValue();
                if (ActionMode.Standalone.isPrior(ActuatorComponent.this.getActionMode()) && ActuatorComponent.this.acceptCcmAction(ActionMode.Standalone, ccm)) {
                    exeMode = ActionMode.Standalone;
                } else if (ActionMode.Autonomy.isPrior(ActuatorComponent.this.getActionMode()) && ActuatorComponent.this.acceptCcmAction(ActionMode.Autonomy, ccm)) {
                    exeMode = ActionMode.Autonomy;
                } else if (ActionMode.rcA.isPrior(ActuatorComponent.this.getActionMode()) && service == ActuatorComponent.this.getActiveRcAService()) {
                    exeMode = num == null || num.intValue() < -100 || num.intValue() > 100 ? (ActuatorComponent.this.getAction(ActionMode.Autonomy) != null ? ActionMode.Autonomy : ActionMode.Standalone) : ActionMode.rcA;
                } else if (ActionMode.WEB.isPrior(ActuatorComponent.this.getActionMode()) && ActuatorComponent.this.acceptCcmAction(ActionMode.WEB, ccm)) {
                    exeMode = ActionMode.WEB;
                } else if (ActionMode.rcM.isPrior(ActuatorComponent.this.getActionMode()) && service == ActuatorComponent.this.getActiveRcMService()) {
                    exeMode = num == null || num.intValue() < -100 || num.intValue() > 100 ? (ActuatorComponent.this.getAction(ActionMode.WEB) != null ? ActionMode.WEB : (ActuatorComponent.this.getActiveRcAService() != null ? ActionMode.rcA : ActionMode.Standalone)) : ActionMode.rcM;
                } else if (ActionMode.Interlock.isPrior(ActuatorComponent.this.getActionMode()) && ActuatorComponent.this.acceptCcmAction(ActionMode.Interlock, ccm)) {
                    exeMode = ActionMode.Interlock;
                }
                if (exeMode != null) {
                    ActuatorComponent.this.changeMode(exeMode);
                    IActuatorAction action = ActuatorComponent.this.getAction(exeMode);
                    if (action != null) {
                        action.execute(ActuatorComponent.this);
                    }
                }
            }
            catch (Exception e) {
                try {
                    ActuatorComponent.this.changeMode(ActionMode.Outage);
                }
                catch (Exception e2) {
                    ActuatorComponent.this.notifyException(e2);
                }
                ActuatorComponent.this.notifyException(e);
            }
        }

        @Override
        public synchronized void ccmExpired(CcmService service, Ccm ccm) {
            try {
                ActionMode exeMode = null;
                switch (ActuatorComponent.this.getActionMode()) {
                    case Outage: {
                        break;
                    }
                    case Interlock: {
                        if (!ActuatorComponent.this.isInactive(ActionMode.Interlock)) break;
                        exeMode = ActionMode.rcM;
                    }
                    case rcM: {
                        if (ActuatorComponent.this.getActiveRcMService() != null) break;
                        exeMode = ActionMode.WEB;
                    }
                    case WEB: {
                        if (!ActuatorComponent.this.isInactive(ActionMode.WEB)) break;
                        exeMode = ActionMode.rcA;
                    }
                    case rcA: {
                        if (ActuatorComponent.this.getActiveRcAService() != null) break;
                        exeMode = ActionMode.Autonomy;
                    }
                    case Autonomy: {
                        if (!ActuatorComponent.this.isInactive(ActionMode.Autonomy)) break;
                        exeMode = ActionMode.Standalone;
                    }
                }
                if (exeMode != null) {
                    ActuatorComponent.this.changeMode(exeMode);
                    IActuatorAction action = ActuatorComponent.this.getAction(exeMode);
                    if (action != null) {
                        action.execute(ActuatorComponent.this);
                    }
                }
            }
            catch (Exception e) {
                ActuatorComponent.this.actionMode = ActionMode.Outage;
                if (ActuatorComponent.this.modeActions.get((Object)ActionMode.Outage) != null) {
                    try {
                        ((IActuatorAction)ActuatorComponent.this.modeActions.get((Object)ActionMode.Outage)).execute(ActuatorComponent.this);
                    }
                    catch (Exception e2) {
                        ActuatorComponent.this.notifyException(e2);
                    }
                }
                ActuatorComponent.this.notifyException(e);
            }
        }

        @Override
        public void ccmSent(CcmService source, Ccm value) {
        }

        @Override
        public void ccmReceived(CcmService source, Ccm value) {
        }
    }
}

